/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc;

import info.informatica.doc.DocumentException;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentPosition
implements Comparable<FragmentPosition> {
    public int ini;
    int sz;

    public FragmentPosition() {
        this(0, 0);
    }

    public FragmentPosition(int ini, int size) {
        this.ini = ini;
        this.sz = size;
    }

    public FragmentPosition(FragmentPosition pos) {
        this(pos.ini, pos.sz);
    }

    public final int getStart() {
        return this.ini;
    }

    public final int getEnd() {
        return this.ini + this.sz;
    }

    public void setEnd(int post_end) {
        this.sz = post_end - this.ini;
    }

    public final int size() {
        return this.sz;
    }

    public void set(FragmentPosition pos) {
        this.ini = pos.ini;
        this.sz = pos.sz;
    }

    public void shift(int offset) {
        this.ini += offset;
    }

    public static FragmentPosition enclosed(FragmentPosition start_tag, FragmentPosition close_tag) throws DocumentException {
        int enc_ini = start_tag.getEnd();
        int enc_sz = close_tag.ini - enc_ini;
        if (enc_sz == 0) {
            return null;
        }
        if (enc_sz < 0) {
            throw new DocumentException("Enclosing tags overlap or are inverted");
        }
        return new FragmentPosition(enc_ini, enc_sz);
    }

    public static FragmentPosition merge(FragmentPosition start_tag, FragmentPosition close_tag) throws DocumentException {
        int mrg_ini = start_tag.ini;
        int mrg_sz = close_tag.ini - mrg_ini + close_tag.sz;
        if (mrg_sz <= 0) {
            throw new DocumentException("Enclosing tags overlap or are inverted");
        }
        return new FragmentPosition(mrg_ini, mrg_sz);
    }

    public boolean equals(Object obj) {
        return this.ini == ((FragmentPosition)obj).ini && this.sz == ((FragmentPosition)obj).sz;
    }

    public int hashCode() {
        return 300 * this.ini + this.sz;
    }

    public String toString() {
        return String.valueOf('(') + Integer.toString(this.getStart()) + '-' + Integer.toString(this.getEnd()) + ')';
    }

    @Override
    public int compareTo(FragmentPosition o) {
        return new FragmentPositionComp().compare(this, o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentPositionComp
    implements Comparator<FragmentPosition> {
        @Override
        public int compare(FragmentPosition o1, FragmentPosition o2) {
            int i1 = o1.ini;
            int i2 = o2.ini;
            return i1 - i2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotFragmentPositionComp
    implements Comparator<FragmentPosition> {
        @Override
        public int compare(FragmentPosition o1, FragmentPosition o2) {
            int i1 = o1.ini;
            int i2 = o2.ini;
            return i2 - i1;
        }
    }
}

