/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc;

import info.informatica.doc.DocumentFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;

public abstract class TextDocument
extends DocumentFile {
    private String lang = null;

    public abstract void load(String var1);

    public void load(InputStream is) throws IOException {
        this.load(new BufferedReader(new InputStreamReader(is)));
    }

    public void load(Reader re) throws IOException {
        char[] b = new char[4000];
        int n = re.read(b);
        StringBuffer content = new StringBuffer(8000);
        content.append(b, 0, n);
        while (n != -1) {
            n = re.read(b);
            if (n == -1) continue;
            content.append(b, 0, n);
        }
        this.load(content.toString());
    }

    public void write(OutputStream os) throws IOException {
        PrintWriter w = new PrintWriter(os);
        this.write(w);
    }

    public void write(PrintWriter w) throws IOException {
        w.print(this.toString());
    }

    public String getPureText() {
        return this.toPureText();
    }

    public abstract String toPureText();

    public String getLanguage() {
        return this.lang;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.toString().getBytes());
    }

    public abstract String toString();

    public String getMetaInfo(String metaname) {
        return null;
    }

    public abstract Enumeration getKeywords();
}

