/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.AssociationException;
import info.informatica.io.ClassAssociation;
import info.informatica.io.Invocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;

public class Associator {
    private Map<String, ClassAssociation> assocmap = new HashMap<String, ClassAssociation>();

    public Associator(InputStream is) throws AssociationException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("associator/association", ClassAssociation.class);
        digester.addObjectCreate("associator/association/invocation", Invocator.class);
        digester.addCallMethod("associator/association/invocation/argument-list/argument", "addArgument", 3);
        digester.addCallParam("associator/association/invocation/argument-list/argument/arg-class", 0);
        digester.addCallParam("associator/association/invocation/argument-list/argument/arg-class", 1);
        digester.addCallParam("associator/association/invocation/argument-list/argument/arg-class", 2);
        digester.addCallMethod("associator/association/invocation/member-name", "setMemberName", 0);
        digester.addSetNext("associator/association/invocation", "addInvocation");
        try {
            digester.parse(is);
        }
        catch (Exception e) {
            throw new AssociationException("Cannot parse file", e);
        }
    }

    public Associator() {
        try {
            ClassAssociation assoc = new ClassAssociation("java.util.Properties");
            Invocator inv = new Invocator();
            assoc.addInvocation(inv);
            inv = new Invocator();
            inv.addArgument("java.io.InputStream", "InputStream", "java.io.InputStream");
            inv.setMemberName("load");
            assoc.addInvocation(inv);
            this.assocmap.put("properties", assoc);
        }
        catch (AssociationException e) {
            throw new IllegalStateException(e.getLocalizedMessage());
        }
    }

    public void addAssociation(String ext, ClassAssociation assoc) {
        this.assocmap.put(ext, assoc);
    }

    public ClassAssociation getAssociation(String ext) {
        return this.assocmap.get(ext);
    }

    public Object create(InputStream is, URL url, String ext) throws IOException, AssociationException {
        ClassAssociation assoc = this.getAssociation(ext);
        if (assoc == null) {
            return null;
        }
        return assoc.create(is, url);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("<associator>\n");
        for (Map.Entry<String, ClassAssociation> me : this.assocmap.entrySet()) {
            String ext = me.getKey();
            ClassAssociation assoc = me.getValue();
            sb.append("<association>\n<extension>\n").append(ext).append("\n</extension>\n").append(assoc.toString());
        }
        sb.append("\n</associator>");
        return sb.toString();
    }
}

