/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.AssociationException;
import info.informatica.io.Invocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassAssociation {
    private Class cls = null;
    private List<Invocator> invocators = new ArrayList<Invocator>();
    private List<AccessibleObject> methods = new ArrayList<AccessibleObject>();

    public ClassAssociation(Class cls) {
        this.cls = cls;
    }

    public ClassAssociation(String classname) throws AssociationException {
        try {
            this.cls = Class.forName(classname);
        }
        catch (Exception e) {
            throw new AssociationException(e);
        }
    }

    public synchronized void addInvocation(Invocator inv) throws AssociationException {
        this.invocators.add(inv);
        String membername = inv.getMemberName();
        try {
            if (membername == null) {
                this.methods.add(inv.getConstructor(this.cls));
            } else {
                this.methods.add(inv.getMethod(this.cls));
            }
        }
        catch (Exception e) {
            throw new AssociationException(e);
        }
    }

    public Object create(InputStream is, URL url) throws IOException, AssociationException {
        Object obj = null;
        Iterator<Invocator> it = this.invocators.iterator();
        Iterator<AccessibleObject> met = this.methods.iterator();
        while (it.hasNext()) {
            try {
                Invocator inv = it.next();
                String membername = inv.getMemberName();
                List<String> types = inv.getArgTypes();
                List<String> uses = inv.getArgUses();
                Object[] args = new Object[types.size()];
                int i = 0;
                while (i < args.length) {
                    args[i] = this.useArgument(is, url, types.get(i), uses.get(i));
                    ++i;
                }
                if (obj == null) {
                    if (membername == null) {
                        ((Constructor)met.next()).newInstance(args);
                        continue;
                    }
                    ((Method)met.next()).invoke(obj, args);
                    continue;
                }
                ((Method)met.next()).invoke(obj, args);
            }
            catch (Exception e) {
                throw new AssociationException(e);
            }
        }
        return obj;
    }

    protected Object useArgument(InputStream is, URL url, String argtype, String use) throws IOException, IllegalAccessException {
        Object arg = null;
        if (argtype.equals("InputStream")) {
            if (use.equals("java.io.InputStream")) {
                arg = is;
            } else if (use.equals("java.io.Reader")) {
                arg = new InputStreamReader(is);
            } else if (use.equals("java.lang.String")) {
                int c;
                BufferedReader re = new BufferedReader(new InputStreamReader(is));
                StringWriter sw = new StringWriter(4000);
                char[] b = new char[10000];
                while ((c = re.read(b)) != -1) {
                    sw.write(b, 0, c);
                }
                arg = sw.toString();
            }
        } else if (argtype.equals("URL")) {
            if (use.equals("FileName")) {
                arg = ClassAssociation.getFilename(url);
            } else if (use.equals("File")) {
                arg = ClassAssociation.getFile(url);
            } else if (use.equals("Parent")) {
                arg = ClassAssociation.getParent(url);
            } else {
                throw new IllegalAccessException("Unknown use: " + use);
            }
        }
        return arg;
    }

    protected static String getFile(URL url) {
        return url.getFile();
    }

    protected static String getFilename(URL url) {
        File f = new File(url.getFile());
        return f.getName();
    }

    protected static String getParent(URL url) {
        File f = new File(url.getFile());
        return f.getParent();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(170);
        sb.append("<class-name>\n").append(this.cls.getName()).append("\n</class-name>");
        Iterator<Invocator> it = this.invocators.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        return sb.toString();
    }
}

