/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.InputLimitException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LimitedInputStream
extends FilterInputStream {
    protected int maxsz;
    protected static final int DEFAULT_MAX_ISTREAM_SIZE = 0x4000000;
    protected int total = 0;

    public LimitedInputStream(InputStream is, int maxsize) {
        super(is);
        this.maxsz = maxsize;
    }

    public LimitedInputStream(InputStream is) {
        this(is, 0x4000000);
    }

    public int write(OutputStream os) throws IOException {
        int n;
        byte[] b = new byte[3000];
        while ((n = super.read(b)) != -1) {
            this.sumBytes(n);
            this.checkLimit();
            os.write(b, 0, n);
        }
        return this.total;
    }

    public int getBytesTransferred() {
        return this.total;
    }

    public int read() throws IOException {
        this.checkLimit();
        int i = super.read();
        if (i >= 0) {
            this.sumBytes(1);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        this.checkLimit();
        int i = super.read(b);
        this.sumBytes(i);
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkLimit();
        int i = super.read(b, off, len);
        this.sumBytes(i);
        return i;
    }

    protected void sumBytes(int n) {
        this.total += n;
    }

    protected void checkLimit() {
        if (this.maxsz != 0 && this.total > this.maxsz) {
            throw new InputLimitException("Se supero el l\u00edmite");
        }
    }
}

