/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.FilePatternSpec;
import info.informatica.io.FilesystemInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class WildcardFilter
implements FilenameFilter,
FileFilter {
    private FilesystemInfo fsinfo = null;
    private FilePatternSpec fpspec = null;
    private FilePatternSpec.FilePattern[] pathdirs;
    private String canonpath;
    private String canonpath_disk;
    private int dircount;

    public WildcardFilter() {
        this(new FilesystemInfo());
    }

    public WildcardFilter(FilesystemInfo filesystemInfo) {
        this.fsinfo = filesystemInfo;
    }

    public FilePatternSpec getFilePatternSpec() {
        return this.fpspec;
    }

    public void setWildcardPath(String path) {
        this.fpspec = new FilePatternSpec(this.fsinfo);
        FilesystemInfo.TokenizedPath tpath = this.fsinfo.getTokenizedPath(path);
        this.dircount = tpath.tokenCount();
        this.pathdirs = new FilePatternSpec.FilePattern[this.dircount];
        int i = 0;
        Iterator<String> it = tpath.iterator();
        while (it.hasNext()) {
            this.pathdirs[i] = this.fpspec.getFilePattern(it.next());
            ++i;
        }
        this.canonpath_disk = tpath.getVolumePrefix();
        this.canonpath = tpath.getAbsolutePath();
    }

    public String getCanonWildcardPath() {
        return this.fsinfo.getQualifiedPath(this.canonpath_disk, this.canonpath);
    }

    public boolean accept(File dir, String name) {
        String s;
        try {
            s = dir.getCanonicalPath();
        }
        catch (IOException e) {
            s = dir.getAbsolutePath();
        }
        if (!this.fsinfo.casesens) {
            s = s.toLowerCase();
            name = name.toLowerCase();
        }
        if ((s = this.fsinfo.getVolumePath(this.canonpath_disk, s)) == null) {
            return false;
        }
        int i = -1;
        StringTokenizer st = new StringTokenizer(s, this.fsinfo.file_separator);
        while (st.hasMoreTokens()) {
            if (++i != this.dircount - 1 && this.pathdirs[i].match(st.nextToken())) continue;
            return false;
        }
        if (i < this.dircount - 2) {
            return false;
        }
        return this.pathdirs[this.dircount - 1].match(name);
    }

    public boolean accept(File pathname) {
        String path;
        try {
            path = pathname.getCanonicalPath();
        }
        catch (IOException e) {
            path = pathname.getAbsolutePath();
        }
        return this.accept(path);
    }

    public boolean accept(String path) {
        String s = !this.fsinfo.casesens ? path.toLowerCase() : path;
        if ((s = this.fsinfo.getVolumePath(this.canonpath_disk, s)) == null) {
            return false;
        }
        int i = -1;
        StringTokenizer st = new StringTokenizer(s, this.fsinfo.file_separator);
        while (st.hasMoreTokens()) {
            if (++i == this.dircount || !this.pathdirs[i].match(st.nextToken())) break;
        }
        return false;
    }

    public String[] getFilterDirs(String path) {
        if (path == null) {
            return null;
        }
        String nwc = this.fpspec.getNonWildcardPath(path);
        File dir = new File(nwc);
        if (!dir.isDirectory()) {
            return null;
        }
        WildcardFilter filt = new WildcardFilter(this.fsinfo);
        filt.setWildcardPath(path);
        String[] list = dir.list(filt);
        int j = 0;
        int i = 0;
        while (i < list.length) {
            list[i] = String.valueOf(nwc) + list[i];
            dir = new File(list[i]);
            if (!dir.isDirectory()) {
                list[i] = null;
            } else {
                ++j;
            }
            ++i;
        }
        String[] fdirs = new String[j];
        int i2 = 0;
        int k = 0;
        while (i2 < list.length) {
            if (list[i2] != null) {
                fdirs[k] = this.mergeWildcard(list[i2]);
                ++k;
            }
            ++i2;
        }
        return fdirs;
    }

    public String[] getAllDirs() {
        String fwc = this.fsinfo.getQualifiedPath(this.canonpath_disk, this.fpspec.getFirstWildcardPath(this.canonpath));
        if (fwc == null) {
            String[] bdirs = new String[]{this.fsinfo.getQualifiedPath(this.canonpath_disk, this.canonpath)};
            return bdirs;
        }
        String[] dirs = this.getFilterDirs(fwc);
        if (dirs == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>(dirs.length);
        int c = 1;
        while (c != 0) {
            v.clear();
            c = 0;
            int i = 0;
            while (i < dirs.length) {
                fwc = this.fpspec.getFirstWildcardPath(dirs[i]);
                String[] bdirs = this.getFilterDirs(fwc);
                if (bdirs != null) {
                    int j = 0;
                    while (j < bdirs.length) {
                        v.add(bdirs[j]);
                        ++c;
                        ++j;
                    }
                }
                ++i;
            }
        }
        return v.toArray(dirs);
    }

    public String mergeWildcard(String path) {
        int i = -1;
        path = this.fsinfo.getVolumePath(this.canonpath_disk, path);
        StringTokenizer st = new StringTokenizer(path, this.fsinfo.file_separator);
        while (st.hasMoreTokens()) {
            if (++i != this.dircount - 1 && this.pathdirs[i].match(st.nextToken())) continue;
            return null;
        }
        StringBuffer sb = new StringBuffer(path.length() + 18 * (this.dircount - i));
        sb.append(path);
        ++i;
        while (i < this.dircount) {
            sb.append(this.fsinfo.file_separator).append(this.pathdirs[i].toString());
            ++i;
        }
        return this.fsinfo.getQualifiedPath(this.canonpath_disk, sb.toString());
    }
}

