/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.lang;

import info.informatica.doc.xml.XMLPrintable;
import info.informatica.lang.XMLStackTracePrinter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XMLExceptionPrinter
implements XMLPrintable {
    Throwable t = null;

    public XMLExceptionPrinter(Throwable t) {
        this.t = t;
    }

    public String getXMLNamespaceURI() {
        return "http://www.informatica.info/projects/jclf/doc/api/info/informatica/lang/";
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, 2, 2);
    }

    public void printXML(PrintWriter pw, int indentbase, int indentdelta) {
        int i;
        int i2 = 0;
        while (i2 < indentbase) {
            pw.append(' ');
            ++i2;
        }
        pw.write("<exception class=\"");
        pw.write(this.t.getClass().getName());
        pw.write("\">\n");
        String msg = this.t.getMessage();
        if (msg != null) {
            i = 0;
            while (i < indentbase + indentdelta) {
                pw.append(' ');
                ++i;
            }
            pw.write("<error-message>\n");
            i = 0;
            while (i < indentbase + indentdelta * 2) {
                pw.append(' ');
                ++i;
            }
            pw.write("<![CDATA[\n");
            i = 0;
            while (i < indentbase + indentdelta * 2) {
                pw.append(' ');
                ++i;
            }
            pw.write(msg);
            pw.write(10);
            i = 0;
            while (i < indentbase + indentdelta * 2) {
                pw.append(' ');
                ++i;
            }
            pw.write("]]>\n");
            i = 0;
            while (i < indentbase + indentdelta) {
                pw.append(' ');
                ++i;
            }
            pw.write("</error-message>\n");
        }
        i = 0;
        while (i < indentbase) {
            pw.append(' ');
            ++i;
        }
        pw.write("</exception>\n");
        XMLStackTracePrinter stp = new XMLStackTracePrinter(this.t);
        stp.printXML(pw, indentbase, indentdelta);
    }

    public String toXML() {
        StringWriter sw = new StringWriter(1000);
        sw.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.printXML(new PrintWriter(sw), 0, 2);
        return sw.toString();
    }
}

