/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.lang;

import info.informatica.doc.xml.XMLPrintable;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XMLStackTracePrinter
implements XMLPrintable {
    private StackTraceElement[] stack;

    public XMLStackTracePrinter(Throwable t) {
        this.stack = t.getStackTrace();
    }

    public String getXMLNamespaceURI() {
        return "http://www.informatica.info/projects/jclf/doc/api/info/informatica/doc/xml/";
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, 2, 2);
    }

    public void printXML(PrintWriter pw, int indentbase, int indentdelta) {
        if (this.stack.length == 0) {
            return;
        }
        int i = 0;
        while (i < indentbase) {
            pw.append(' ');
            ++i;
        }
        pw.write("<stack-trace>\n");
        i = 0;
        while (i < this.stack.length) {
            int j = 0;
            while (j < indentbase + indentdelta) {
                pw.append(' ');
                ++j;
            }
            pw.write("<trace-element>\n");
            j = 0;
            while (j < indentbase + indentdelta + indentdelta) {
                pw.append(' ');
                ++j;
            }
            pw.write(this.stack[i].toString());
            pw.append('\n');
            j = 0;
            while (j < indentbase + indentdelta) {
                pw.append(' ');
                ++j;
            }
            pw.write("</trace-element>\n");
            ++i;
        }
        i = 0;
        while (i < indentbase) {
            pw.append(' ');
            ++i;
        }
        pw.write("</stack-trace>\n");
    }

    public String toXML() {
        StringWriter sw = new StringWriter(1024);
        sw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        this.printXML(new PrintWriter(sw), 0, 2);
        return sw.toString();
    }
}

