/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

import info.informatica.net.HostNameException;
import java.io.Serializable;

public final class HostName
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String fqdn;

    public HostName(String s) throws HostNameException {
        s = s.trim().toLowerCase();
        if (!HostName.checkValid(s)) {
            throw new HostNameException("Invalid host name");
        }
        if (s.charAt(s.length() - 1) == '.') {
            s = s.substring(0, s.length() - 1);
        }
        this.fqdn = s;
    }

    public static boolean checkValid(String s) {
        return s.length() >= 2;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public static String getTopDomain(String fqdn) {
        if (fqdn == null) {
            return null;
        }
        String s = fqdn.trim();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String getRootDomain(String fqdn) throws HostNameException {
        if (fqdn == null) {
            return null;
        }
        String s = HostName.getSubDomain(fqdn.trim());
        return s.substring(s.indexOf(46) + 1);
    }

    public static String getSubDomain(String fqdn) throws HostNameException {
        int j;
        if (fqdn == null) {
            return null;
        }
        int i = (fqdn = fqdn.trim().toLowerCase()).lastIndexOf(46);
        if (i < 0) {
            return fqdn;
        }
        if (i == fqdn.length() - 1) {
            fqdn = fqdn.substring(0, i);
            i = fqdn.lastIndexOf(46);
        }
        if ((j = fqdn.lastIndexOf(46, i - 1)) < 0) {
            return fqdn;
        }
        if (++j == i) {
            throw new HostNameException("Invalid host name");
        }
        if (("com".equals(fqdn.substring(j, i)) || "net".equals(fqdn.substring(j, i)) || "ac".equals(fqdn.substring(j, i)) || "co".equals(fqdn.substring(j, i)) || "name".equals(fqdn.substring(j, i)) || "edu".equals(fqdn.substring(j, i)) || "org".equals(fqdn.substring(j, i))) && (j = fqdn.lastIndexOf(46, j - 2) + 1) == 0) {
            return fqdn;
        }
        return fqdn.substring(j);
    }
}

