/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

import info.informatica.util.CacheException;
import info.informatica.util.DatedContainer;
import info.informatica.util.ObjectCache;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLDnsCache
extends ObjectCache {
    protected Connection con = null;
    protected String datasrc;
    protected String db_user = null;
    protected String db_passwd = null;
    protected PreparedStatement stmt_get;
    protected PreparedStatement stmt_put;
    protected PreparedStatement stmt_del;
    protected long exptime = 10368000000L;
    private transient String lastip = null;
    private transient DatedContainer<String> lastdc = null;

    @Override
    public void init(Properties conf) throws CacheException {
        String s = conf.getProperty("dns.cache.jdbcdriver");
        try {
            Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("JDBC_DRIVER_NOT_FOUND");
        }
        this.datasrc = conf.getProperty("dns.cache.datasource");
        this.db_user = conf.getProperty("dns.cache.dbuser");
        this.db_passwd = conf.getProperty("dns.cache.dbpasswd");
        try {
            this.con = this.openDbConnection();
            if (!SQLDnsCache.dbExists(this.con, "dnscache")) {
                Statement st = this.con.createStatement();
                st.execute("CREATE TABLE IF NOT EXISTS dnscache (ip varchar(15) not null primary key, cname varchar(64), fecha BIGINT)");
                st.close();
            }
            this.stmt_get = this.con.prepareStatement("SELECT cname, fecha FROM dnscache WHERE ip = ?");
            this.stmt_put = this.con.prepareStatement("REPLACE INTO dnscache (ip, cname, fecha) VALUES (?, ?, ?)");
            this.stmt_del = this.con.prepareStatement("DELETE FROM dnscache WHERE ip = ?");
        }
        catch (SQLException e) {
            throw new CacheException(e.getMessage());
        }
        s = conf.getProperty("dns.cache.expire");
        if (s != null) {
            this.setExpireTime(Long.parseLong(s));
        }
    }

    private synchronized Connection openDbConnection() throws SQLException {
        return DriverManager.getConnection(this.datasrc, this.db_user, this.db_passwd);
    }

    private static boolean dbExists(Connection con, String tablename) throws SQLException {
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = md.getTables(null, null, "dnscache", null);
        boolean bo = rs.next();
        rs.close();
        return bo;
    }

    @Override
    public void setExpireTime(long t) {
        this.exptime = t * 1000L;
    }

    @Override
    public String lookupString(String ip) {
        DatedContainer<String> dc = this.lookup(ip);
        if (dc == null) {
            return null;
        }
        String s = dc.getObject();
        dc = null;
        if (s == null) {
            return "";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatedContainer<String> lookup(String ip) {
        if (ip.equals(this.lastip)) {
            return this.lastdc;
        }
        String h = null;
        long t = 0L;
        boolean cached = false;
        PreparedStatement preparedStatement = this.stmt_get;
        synchronized (preparedStatement) {
            ResultSet rs = null;
            try {
                try {
                    this.stmt_get.clearParameters();
                    this.stmt_get.setString(1, ip);
                    rs = this.stmt_get.executeQuery();
                    if (rs.next()) {
                        h = rs.getString(1);
                        t = rs.getLong(2);
                        cached = true;
                    }
                }
                catch (SQLException sQLException) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!cached) {
            this.lastip = ip;
            this.lastdc = null;
            return null;
        }
        if (new Date().getTime() - t > this.exptime) {
            return null;
        }
        this.lastip = ip;
        this.lastdc = new DatedContainer<String>(new Date(t), h);
        return this.lastdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String ip, String name) {
        if (ip != null) {
            Connection connection = this.con;
            synchronized (connection) {
                try {
                    this.stmt_put.clearParameters();
                    this.stmt_put.setString(1, ip);
                    this.stmt_put.setString(2, name);
                    this.stmt_put.setLong(3, new Date().getTime());
                    this.stmt_put.executeUpdate();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized void put(String ip, DatedContainer<String> dc) {
        this.put(ip, dc.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws CacheException {
        try {
            if (this.stmt_get != null) {
                this.stmt_get.close();
            }
            if (this.stmt_put != null) {
                this.stmt_put.close();
            }
            if (this.stmt_del != null) {
                this.stmt_del.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Connection connection = this.con;
        synchronized (connection) {
            if (this.con != null) {
                try {
                    this.con.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

