/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.text.NumberFormat;
import java.util.Random;

public class FloatFormat
extends NumberFormat {
    private boolean zeropadding = false;
    private boolean numpre = false;

    public FloatFormat() {
        this.precision = 6;
    }

    protected boolean setFlag(char flag, int i) {
        if (!super.setFlag(flag, i)) {
            switch (flag) {
                case '0': {
                    if (i != this.flags.length - 1 || this.ralign) break;
                    this.zeropadding = true;
                    break;
                }
                case '#': {
                    this.numpre = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String format(Object o) {
        if (!(o instanceof Double) && !(o instanceof Float)) {
            throw new IllegalArgumentException("Object must be an Double or a Float");
        }
        return this.roundNumber((Number)o);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.numpre) {
            sb.append('#');
        }
        if (this.zeropadding) {
            sb.append('0');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision >= 0) {
            sb.append('.').append(this.precision);
        }
        sb.append('f');
        return sb.toString();
    }

    public Object sample() {
        return new Double(new Random().nextDouble() * 10.0);
    }
}

