/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.text.ObjectFormat;
import info.informatica.text.ParsingException;
import info.informatica.text.StringFormat;
import info.informatica.text.TemplateItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatPrinter {
    protected String formato;
    protected List<TemplateItem> items = new ArrayList<TemplateItem>();
    private String nullStrText = null;
    static Logger log = Logger.getLogger((String)FormatPrinter.class.getName());

    public FormatPrinter(String format) throws ParsingException {
        this(format, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPrinter(String format, String nullStrText) throws ParsingException {
        int i;
        this.nullStrText = nullStrText;
        this.formato = format;
        StringBuilder sb = new StringBuilder(format.length());
        boolean subst = false;
        int j = 0;
        while ((i = this.formato.indexOf(36, j)) >= 0) {
            sb.append(format.substring(j, i));
            j = format.indexOf(123, ++i);
            if (j == -1) {
                j = i + 1;
                continue;
            }
            if (i == j) {
                if ((j = format.indexOf(125, ++i)) < 0) throw new ParsingException("Unmatched '${' pair at char " + Integer.toString(i));
                String s = format.substring(i, j);
                int k = s.indexOf(44);
                int pos = sb.length();
                if (k < 0) {
                    StringFormat sf = new StringFormat();
                    ((ObjectFormat)sf).setFormat("s");
                    TemplateItem item = new TemplateItem(s.trim(), sf, pos);
                    this.items.add(item);
                } else {
                    TemplateItem item = new TemplateItem(s.substring(0, k).trim(), ObjectFormat.create(s.substring(k + 1).trim()), pos);
                    this.items.add(item);
                }
            } else {
                sb.append('$');
                j = i - 1;
            }
            ++j;
        }
        sb.append(format.substring(j));
        this.formato = sb.toString();
    }

    public String format(ResultSet env) throws SQLException {
        int l = this.formato.length();
        StringBuffer sb = new StringBuffer((int)((double)l * 1.2));
        Iterator<TemplateItem> it = this.items.iterator();
        int j = 0;
        while (it.hasNext()) {
            TemplateItem item = it.next();
            int i = item.getPos();
            sb.append(this.formato.substring(j, i));
            Object o = env.getObject(item.getName());
            if (o instanceof java.sql.Date) {
                o = new Date(((java.sql.Date)o).getTime());
            }
            this.addFormattedObject(sb, item, o);
            j = i;
        }
        if (j < l) {
            sb.append(this.formato.substring(j));
        }
        return sb.toString();
    }

    public String format(Map<String, ? extends Object> env) {
        int l = this.formato.length();
        StringBuffer sb = new StringBuffer((int)((double)l * 1.2));
        Iterator<TemplateItem> it = this.items.iterator();
        int j = 0;
        while (it.hasNext()) {
            TemplateItem item = it.next();
            int i = item.getPos();
            sb.append(this.formato.substring(j, i));
            Object o = env.get(item.getName());
            this.addFormattedObject(sb, item, o);
            j = i;
        }
        if (j < l) {
            sb.append(this.formato.substring(j));
        }
        return sb.toString();
    }

    public String sample() {
        HashMap<String, Object> samples = new HashMap<String, Object>();
        Iterator<TemplateItem> it = this.getFormats();
        while (it.hasNext()) {
            TemplateItem item = it.next();
            ObjectFormat of = item.getFormat();
            samples.put(item.getName(), of.sample());
        }
        return this.format(samples);
    }

    protected void addFormattedObject(StringBuffer sb, TemplateItem item, Object o) {
        if (o != null) {
            try {
                sb.append(item.getFormat().format(o));
            }
            catch (RuntimeException e) {
                String msg = "Cannot format object of name " + item.getName() + ", value: " + (o == null ? "null" : o.toString());
                throw new RuntimeException(msg, e);
            }
        } else if (this.nullStrText != null) {
            sb.append(this.nullStrText);
        } else {
            sb.append(item.toString());
        }
    }

    public Iterator<TemplateItem> getFormats() {
        return this.items.iterator();
    }

    public boolean hasArguments() {
        return !this.items.isEmpty();
    }

    public String toString() {
        return this.formato;
    }
}

