/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.text.NumberFormat;
import info.informatica.text.StringUtil;
import java.util.Random;

public final class IntegerFormat
extends NumberFormat {
    public IntegerFormat() {
        this.precision = 1;
    }

    public String format(Object o) {
        if (!(o instanceof Integer || o instanceof Long || o instanceof Short)) {
            throw new IllegalArgumentException("Object must be an Integer, Short or Long");
        }
        StringBuffer sb = new StringBuffer(14);
        this.rightAppend(sb, o.toString().trim(), '0', this.precision, 0);
        if (this.width > 0) {
            if (this.ralign) {
                return StringUtil.rightJustify(sb.toString(), ' ', this.width, '%');
            }
            return StringUtil.leftJustify(sb.toString(), ' ', this.width, '%');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision > 0 && this.precision != this.width) {
            sb.append('.').append(this.precision);
        }
        sb.append('d');
        return sb.toString();
    }

    public Object sample() {
        return new Integer(new Random().nextInt());
    }
}

