/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.text.ObjectFormat;
import info.informatica.text.ParsingException;

public abstract class NumberFormat
extends ObjectFormat {
    protected char tipo;
    protected boolean signpre = false;
    protected boolean blankpre = false;
    protected transient long roundfactor;

    protected NumberFormat() {
    }

    protected char setFormat(String format) throws ParsingException {
        this.tipo = super.setFormat(format);
        if (this.precision >= 0) {
            this.roundfactor = (long)Math.pow(10.0, this.precision);
        }
        return this.tipo;
    }

    protected boolean setFlag(char flag, int i) {
        if (!super.setFlag(flag, i)) {
            switch (flag) {
                case '+': {
                    this.signpre = true;
                    break;
                }
                case ' ': {
                    this.blankpre = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected final String roundNumber(Number num) {
        double dnumero = num.doubleValue();
        dnumero = (double)Math.round(dnumero * (double)this.roundfactor) / (double)this.roundfactor;
        String fmtnum = Double.toString(dnumero);
        fmtnum = this.ralign ? this.expandLeftToWidth(fmtnum, ' ') : this.expandRightToWidth(fmtnum);
        return fmtnum;
    }
}

