/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.doc.style.Alignable;
import info.informatica.text.ExponentFormat;
import info.informatica.text.FloatFormat;
import info.informatica.text.HexFormat;
import info.informatica.text.IntegerFormat;
import info.informatica.text.OctalFormat;
import info.informatica.text.ParsingException;
import info.informatica.text.StringFormat;
import info.informatica.text.TemplateDateFormat;
import info.informatica.text.TextFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public abstract class ObjectFormat
implements Alignable {
    protected char[] flags = null;
    protected boolean ralign = true;
    protected int width = 0;
    protected int precision = -1;

    protected ObjectFormat() {
    }

    public static ObjectFormat create(String format) throws ParsingException {
        ObjectFormat o;
        int l = format.length();
        char tipo = format.charAt(l - 1);
        switch (tipo) {
            case 'S': 
            case 's': {
                o = new StringFormat();
                break;
            }
            case 'T': {
                o = new TextFormat();
                break;
            }
            case 'D': {
                o = new TemplateDateFormat();
                break;
            }
            case 'G': 
            case 'f': 
            case 'g': {
                o = new FloatFormat();
                break;
            }
            case 'E': 
            case 'e': {
                o = new ExponentFormat();
                break;
            }
            case 'd': 
            case 'i': 
            case 'u': {
                o = new IntegerFormat();
                break;
            }
            case 'o': {
                o = new OctalFormat();
                break;
            }
            case 'x': {
                o = new HexFormat();
                break;
            }
            default: {
                throw new ParsingException("Unknown type: " + format);
            }
        }
        o.setFormat(format);
        return o;
    }

    public static ObjectFormat create(Class clase, int width, int precision) throws ParsingException {
        if (clase.equals(String.class)) {
            return ObjectFormat.create(clase, width, precision, false);
        }
        return ObjectFormat.create(clase, width, precision, true);
    }

    public static ObjectFormat create(Class clase, int width, int precision, boolean right_align) throws ParsingException {
        ObjectFormat o;
        if (clase.equals(String.class)) {
            o = new StringFormat();
        } else if (clase.equals(Float.class)) {
            o = new FloatFormat();
        } else if (clase.equals(Double.class)) {
            o = new ExponentFormat();
        } else if (clase.equals(Integer.class)) {
            o = new IntegerFormat();
        } else if (clase.equals(Long.class)) {
            o = new IntegerFormat();
        } else if (clase.equals(Date.class) || clase.equals(Timestamp.class) || clase.equals(Time.class)) {
            o = new TemplateDateFormat();
        } else {
            throw new ParsingException("Cannot format class: " + clase.getName());
        }
        o.width = width;
        o.precision = precision;
        o.ralign = right_align;
        return o;
    }

    protected char setFormat(String format) throws ParsingException {
        int l = format.length();
        char tipo = format.charAt(l - 1);
        int i = format.indexOf(46);
        if (i < 0) {
            i = l - 2;
        } else {
            this.precision = Integer.parseInt(format.substring(i + 1, l - 1));
            --i;
        }
        int j = i;
        while (j >= 0) {
            if (!Character.isDigit(format.charAt(j))) break;
            --j;
        }
        this.width = j == i ? 0 : Integer.parseInt(format.substring(j + 1, i + 1));
        this.flags = (char[])(j < 0 ? null : format.substring(0, j + 1).toCharArray());
        if (this.flags != null) {
            this.setFlags(this.flags);
        }
        return tipo;
    }

    protected void setFlags(char[] flags) throws ParsingException {
        int i = 0;
        while (i < flags.length) {
            if (!this.setFlag(flags[i], i)) {
                throw new ParsingException("Unknown or wrong flag: " + flags[i]);
            }
            ++i;
        }
    }

    protected boolean setFlag(char flag, int i) {
        switch (flag) {
            case '-': {
                this.ralign = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected final void rightAppend(StringBuffer sb, String s, char fillchar, int minchars, int maxchars) {
        int len = s.length();
        if (minchars != 0 && len < minchars) {
            int l = minchars - len;
            int i = 0;
            while (i < l) {
                sb.append(fillchar);
                ++i;
            }
            sb.append(s);
            return;
        }
        if (maxchars == 0 || len <= maxchars) {
            sb.append(s);
            return;
        }
        sb.append(s.substring(0, maxchars));
    }

    protected final String expandLeftToWidth(String field, char cjust) {
        if (this.width == 0) {
            return field;
        }
        int l = this.width - field.length();
        if (l <= 0) {
            return field;
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = cjust;
            ++i;
        }
        return new StringBuffer(this.width).append(ca).append(field).toString();
    }

    protected final String expandRightToWidth(String field) {
        if (this.width == 0) {
            return field;
        }
        int l = this.width - field.length();
        if (l <= 0) {
            return field;
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = 32;
            ++i;
        }
        return new StringBuffer(this.width).append(field).append(ca).toString();
    }

    public void align(int i) {
        switch (i) {
            case 2: {
                this.ralign = true;
                break;
            }
            case 1: {
                this.ralign = false;
            }
        }
    }

    public int getAlignment() {
        return this.ralign ? 2 : 1;
    }

    public abstract String format(Object var1);

    public abstract Object sample();
}

