/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

public final class StringUtil {
    static final String vocals = "aeiouAEIOU";
    static final String accents = "\u00e0\u00e8\u00ec\u00f2\u00f9\u00c0\u00c8\u00cc\u00d2\u00d9\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00fc\u00f6\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db";

    public static String rightJustify(String s, char c, int n) {
        return StringUtil.rightJustify(s, c, n, c);
    }

    public static String rightJustify(String s, char c, int n, char overchar) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot right-justify String with zero width");
        }
        int l = n - s.length();
        if (l == 0) {
            return s;
        }
        if (l < 0) {
            return new StringBuffer(n).append(overchar).append(s.substring(-l + 1)).toString();
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        return new StringBuffer(n).append(ca).append(s).toString();
    }

    public static String leftJustify(String s, char c, int n) {
        return StringUtil.leftJustify(s, c, n, c);
    }

    public static String leftJustify(String s, char c, int n, char overchar) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot left-justify String with zero width");
        }
        int l = n - s.length();
        if (l == 0) {
            return s;
        }
        if (l < 0) {
            return new StringBuffer(n).append(s.substring(0, n - 1)).append(overchar).toString();
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        return new StringBuffer(n).append(s).append(ca).toString();
    }

    public static String toTitle(String s) {
        return String.valueOf(Character.toTitleCase(s.charAt(0))) + s.substring(1);
    }

    public static String fillString(String s, char c, int n) {
        int l = n - s.length();
        if (l < 0) {
            return s.substring(0, n);
        }
        StringBuffer sb = new StringBuffer(s);
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        sb.append(ca);
        return sb.toString();
    }

    public static String contractSpaces(String t) {
        int tl = t.length();
        StringBuffer sb = new StringBuffer(tl);
        int ini = 0;
        int fin = 0;
        while ((ini = t.indexOf("  ", fin)) != -1) {
            sb.append(t.substring(fin, ini));
            fin = ini;
            while (++fin < tl && t.charAt(fin) == ' ') {
            }
            --fin;
        }
        sb.append(t.substring(fin));
        return sb.toString();
    }

    public static String filterISOControl(String s) {
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer(c.length);
        int i = 0;
        while (i < c.length) {
            if (!Character.isISOControl(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replaceISOControl(String s, char c) {
        char[] a = s.toCharArray();
        int i = 0;
        while (i < a.length) {
            if (Character.isISOControl(a[i])) {
                a[i] = c;
            }
            ++i;
        }
        return new String(a);
    }

    public static final String replaceNonChars(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] != ' ' && !Character.isLetterOrDigit(c[i])) {
                c[i] = 32;
            }
            ++i;
        }
        return new String(c);
    }

    public static String replaceLowerAccents(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            switch (c[i]) {
                case '\u00e0': 
                case '\u00e1': {
                    c[i] = 97;
                    break;
                }
                case '\u00e8': 
                case '\u00e9': {
                    c[i] = 101;
                    break;
                }
                case '\u00ec': 
                case '\u00ed': {
                    c[i] = 105;
                    break;
                }
                case '\u00f2': 
                case '\u00f3': {
                    c[i] = 111;
                    break;
                }
                case '\u00f9': 
                case '\u00fa': {
                    c[i] = 117;
                }
            }
            ++i;
        }
        return new String(c);
    }

    public static String replace(String s, String q, String pq) {
        return StringUtil.replace(s, q, pq, 1);
    }

    public static String replace(String s, String q, String pq, int n) {
        int slen = s.length();
        int qlen = q.length();
        int buflen = slen + n * (pq.length() - qlen);
        StringBuffer sb = new StringBuffer(buflen > 0 ? buflen : slen);
        int lpos = 0;
        int ini = s.indexOf(q);
        while (ini != -1) {
            sb.append(s.substring(lpos, ini)).append(pq);
            lpos = ini + qlen;
            ini = s.indexOf(q, lpos);
        }
        if (lpos < slen) {
            sb.append(s.substring(lpos));
        }
        return sb.toString();
    }

    public static String omitAccents(String s) {
        StringBuffer sb = new StringBuffer(s);
        int alen = accents.length();
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            int j = 0;
            while (j < alen) {
                if (c == accents.charAt(j)) {
                    sb.setCharAt(i, vocals.charAt(j % 10));
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }
}

