/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text.mapper;

import info.informatica.text.mapper.MapperException;
import info.informatica.text.mapper.TextMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedTextMapper
implements TextMapper {
    protected short[] ma;
    protected List<Object> mb = new ArrayList<Object>();
    protected List<String> mc = new ArrayList<String>();
    protected Properties env = null;
    private PatternMatcher matcher = new Perl5Matcher();
    private PatternCompiler compiler = new Perl5Compiler();
    protected final short LEFT_REPLACE_MAP = 1;
    protected final short RIGHT_REPLACE_MAP = (short)2;
    protected final short REGEXP_REPLACE_MAP = (short)3;
    protected final short REGEXP_MAP = (short)4;
    protected final short LEFT_MOUNT_MAP = (short)5;
    protected final short RIGHT_MOUNT_MAP = (short)6;
    protected final short LEFT_REV_MOUNT_MAP = (short)7;
    protected final short RIGHT_REV_MOUNT_MAP = (short)8;
    protected final short LEFT_REPLACE_MAP_ENV = (short)11;
    protected final short RIGHT_REPLACE_MAP_ENV = (short)12;
    protected final short LEFT_MOUNT_MAP_ENV = (short)15;
    protected final short RIGHT_MOUNT_MAP_ENV = (short)16;
    protected final short LEFT_REV_MOUNT_MAP_ENV = (short)17;
    protected final short RIGHT_REV_MOUNT_MAP_ENV = (short)18;

    public CombinedTextMapper() {
    }

    public CombinedTextMapper(Properties env) {
        this.env = env;
    }

    @Override
    public void init(String initString) throws IOException, MapperException {
        BufferedReader fichero = new BufferedReader(new FileReader(initString));
        this.init(fichero);
        fichero.close();
    }

    @Override
    public void init(Reader re) throws IOException, MapperException {
        BufferedReader fichero = new BufferedReader(re);
        String lm = null;
        ArrayList<Short> la = new ArrayList<Short>();
        while ((lm = fichero.readLine()) != null) {
            int map_type;
            int j;
            int i = lm.indexOf(9);
            if (i < 0 || (j = lm.indexOf(9, i + 1)) < 0 || lm.indexOf(9, j + 1) > 0) {
                throw new IOException("Malformed File format at line: " + lm);
            }
            String ss = lm.substring(0, i);
            if ("LeftReplace".equals(ss)) {
                map_type = 1;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("LeftReplaceEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 11;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else if ("RightReplace".equals(ss)) {
                map_type = 2;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("RightReplaceEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 12;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else if ("RegexpReplace".equals(ss)) {
                try {
                    this.mb.add(this.compiler.compile(lm.substring(i + 1, j), 1));
                }
                catch (MalformedPatternException e) {
                    throw new MapperException("Malformed map entry: " + lm, e);
                }
                map_type = 3;
            } else if ("Regexp".equals(ss)) {
                try {
                    this.mb.add(this.compiler.compile(lm.substring(i + 1, j), 1));
                }
                catch (MalformedPatternException e) {
                    throw new MapperException("Malformed map entry: " + lm, e);
                }
                map_type = 4;
            } else if ("LeftMount".equals(ss)) {
                map_type = 5;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("LeftMountEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 15;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else if ("RightMount".equals(ss)) {
                map_type = 6;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("RightMountEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 16;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else if ("LeftRevMount".equals(ss)) {
                map_type = 7;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("LeftRevMountEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 17;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else if ("RightRevMount".equals(ss)) {
                map_type = 8;
                this.mb.add(lm.substring(i + 1, j));
            } else if ("RightRevMountEnv".equals(ss)) {
                if (this.env == null) {
                    throw new MapperException("Environment not defined for: " + lm);
                }
                map_type = 18;
                ss = this.env.getProperty(lm.substring(i + 1, j));
                this.mb.add(ss);
            } else {
                throw new MapperException("Unknown Map type: " + ss);
            }
            la.add(new Short((short)map_type));
            ss = lm.substring(j + 1);
            if (map_type > 10) {
                ss = this.env.getProperty(ss);
            }
            this.mc.add("".equals(ss) ? null : ss);
        }
        this.ma = new short[la.size()];
        int k = 0;
        while (k < this.ma.length) {
            this.ma[k] = (Short)la.get(k);
            ++k;
        }
    }

    public void init(short[] ma, List<Object> mb, List<String> mc) {
        this.ma = ma;
        this.mb = mb;
        this.mc = mc;
    }

    @Override
    public void addMapping(String b, String c) {
        this.addMapping((short)1, b, c);
    }

    public void addMapping(short a, String b, String c) {
        int i = this.ma.length;
        short[] nsa = new short[i + 1];
        System.arraycopy(this.ma, 0, nsa, 0, i);
        nsa[i] = a;
        this.ma = nsa;
        this.mb.add(b);
        this.mc.add(c);
    }

    @Override
    public String map(String canon) {
        return this.map(canon, null);
    }

    @Override
    public String map(String canon, String unmatch) {
        if (canon == null) {
            return null;
        }
        int i = 0;
        while (i < this.mb.size()) {
            switch (this.ma[i]) {
                case 1: {
                    String mountp = (String)this.mb.get(i);
                    int mountpl = mountp.length();
                    if (canon.length() < mountpl || !canon.substring(0, mountpl).equals(mountp)) break;
                    return this.mc.get(i);
                }
                case 2: {
                    String mountp = (String)this.mb.get(i);
                    int mountpl = mountp.length();
                    if (canon.length() < mountpl || !canon.endsWith(mountp)) break;
                    return this.mc.get(i);
                }
                case 3: {
                    if (!this.matcher.matches(canon, (Pattern)this.mb.get(i))) break;
                    return this.mc.get(i);
                }
                case 4: {
                    if (!this.matcher.matches(canon, (Pattern)this.mb.get(i))) break;
                    return Util.substitute((PatternMatcher)this.matcher, (Pattern)((Pattern)this.mb.get(i)), (Substitution)new Perl5Substitution(this.mc.get(i)), (String)canon);
                }
                case 5: {
                    String mountp = (String)this.mb.get(i);
                    int mountpl = mountp.length();
                    if (canon.length() < mountpl || !canon.substring(0, mountpl).equals(mountp)) break;
                    return String.valueOf(this.mc.get(i)) + canon.substring(mountpl);
                }
                case 6: {
                    String mountp = (String)this.mb.get(i);
                    if (!canon.endsWith(mountp)) break;
                    return String.valueOf(this.mc.get(i)) + canon;
                }
                case 7: {
                    String mountp = (String)this.mb.get(i);
                    int mountpl = mountp.length();
                    if (canon.length() < mountpl || !canon.substring(0, mountpl).equals(mountp)) break;
                    return String.valueOf(canon.substring(mountpl)) + this.mc.get(i);
                }
                case 8: {
                    String mountp = (String)this.mb.get(i);
                    if (!canon.endsWith(mountp)) break;
                    return String.valueOf(canon.substring(0, canon.length() - mountp.length())) + this.mc.get(i);
                }
            }
            ++i;
        }
        return unmatch;
    }

    @Override
    public String map(String canon, String unmatch, String def) {
        String s = this.map(canon, unmatch);
        if (s == null) {
            return def;
        }
        return s;
    }
}

