/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text.mapper;

import info.informatica.text.mapper.MapperException;
import info.informatica.text.mapper.SingleTextMapper;
import info.informatica.text.mapper.TextMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RegexpReplaceMapper
extends SingleTextMapper
implements TextMapper {
    private PatternMatcher matcher = new Perl5Matcher();
    private PatternCompiler compiler = new Perl5Compiler();

    public void init(String s) throws IOException, MapperException {
        String lm;
        BufferedReader fichero = new BufferedReader(new FileReader(s));
        while ((lm = fichero.readLine()) != null) {
            int i = lm.indexOf(9);
            if (i < 0 || lm.indexOf(9, i + 1) > 0) {
                throw new IOException("Malformed File format");
            }
            try {
                this.ma.add(this.compiler.compile(lm.substring(0, i), 1));
            }
            catch (MalformedPatternException e) {
                throw new MapperException("Malformed map entry", e);
            }
            this.mb.add(lm.substring(i + 1));
        }
    }

    public String map(String canon, String unmatch) {
        if (canon == null) {
            return null;
        }
        int i = 0;
        while (i < this.ma.size()) {
            if (this.matcher.matches(canon, (Pattern)this.ma.get(i))) {
                return (String)this.mb.get(i);
            }
            ++i;
        }
        return unmatch;
    }
}

