/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;

public class LocaleEnum {
    private String basename;
    private String ext;
    private int lastdim = 10;

    public LocaleEnum(String baseName, String ext) {
        if (baseName == null) {
            throw new NullPointerException("baseName cannot be null");
        }
        this.basename = baseName;
        this.ext = ext;
    }

    public String[] getBestEnum() {
        return this.getBestEnum(Locale.getDefault());
    }

    public String[] getBestEnum(Locale locale) {
        String[] best = this.getEnum(locale);
        if (best == null) {
            best = this.getEnum();
        }
        return best;
    }

    public String[] getEnum(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale cannot be null");
        }
        InputStream is = this.loadBestLocalizedFile(locale);
        if (is == null) {
            return null;
        }
        return this.getEnumArray(is);
    }

    public String[] getEnum() {
        InputStream is = this.loadLocalizedFile(null);
        if (is == null) {
            throw new IllegalStateException("Cannot find default locale for: " + this.basename);
        }
        return this.getEnumArray(is);
    }

    private String[] getEnumArray(InputStream is) {
        ArrayList<String> enumlst = new ArrayList<String>(this.lastdim);
        BufferedReader re = new BufferedReader(new InputStreamReader(is));
        try {
            try {
                String line;
                while ((line = re.readLine()) != null) {
                    enumlst.add(line);
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            try {
                re.close();
            }
            catch (IOException iOException) {}
        }
        String[] lstarray = enumlst.toArray(new String[0]);
        this.lastdim = lstarray.length;
        this.lastdim = this.lastdim == 0 ? 10 : this.lastdim;
        return lstarray;
    }

    private InputStream loadBestLocalizedFile(Locale locale) {
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        if (co.length() > 0) {
            String localeName;
            InputStream is = null;
            if (va.length() > 0 && (is = this.loadLocalizedFile(localeName = String.valueOf(la) + '_' + co + '_' + va)) != null) {
                return is;
            }
            localeName = String.valueOf(la) + '_' + co;
            is = this.loadLocalizedFile(localeName);
            if (is != null) {
                return is;
            }
        }
        return this.loadLocalizedFile(la);
    }

    private InputStream loadLocalizedFile(String localeName) {
        StringBuffer sb = new StringBuffer(this.basename.length() * 2).append(this.basename);
        if (localeName != null) {
            sb.append('_').append(localeName);
        }
        if (this.ext != null) {
            sb.append('.').append(this.ext);
        }
        final String resName = sb.toString();
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream(resName);
            }
        });
    }
}

