/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.util.locale.ResourceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ObjectBundle {
    private Map<Locale, Object> m_map = new HashMap<Locale, Object>(10);
    private Map<Locale, Locale> m_best = new HashMap<Locale, Locale>(10);
    private String baseName;
    private String ext;
    private Locale default_locale = null;
    private ResourceFactory rf = null;

    public ObjectBundle(String path, ResourceFactory rf) throws IOException {
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        int i = path.lastIndexOf(46);
        if (i > 0) {
            this.baseName = path.substring(0, i);
            this.ext = ++i < path.length() ? path.substring(i) : null;
        } else {
            if (i == 0) {
                throw new NullPointerException("baseName cannot be empty");
            }
            this.baseName = path;
        }
        this.rf = rf;
        this.loadDefaultFile();
    }

    public ObjectBundle(String baseName, String ext, ResourceFactory rf) throws IOException {
        if (baseName == null) {
            throw new NullPointerException("baseName cannot be null");
        }
        this.baseName = baseName;
        this.ext = ext;
        this.rf = rf;
        this.loadDefaultFile();
    }

    public String getExtension() {
        return this.ext != null ? this.ext.toLowerCase() : null;
    }

    public Object get() {
        return this.m_map.get(null);
    }

    public Object getBest(Locale locale) {
        Object o = this.get(locale);
        if (o == null) {
            o = this.get();
        }
        return o;
    }

    public Object get(Locale locale) {
        Object o = null;
        if (this.m_map.containsKey(locale)) {
            o = this.m_map.get(locale);
        } else {
            try {
                o = this.m_map.get(this.loadObject(locale));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return o;
    }

    public Locale getBestLocale(Locale[] loc) {
        Locale best = null;
        if (loc != null) {
            int i = 0;
            while (i < loc.length) {
                if (this.m_best.containsKey(loc[i])) {
                    best = this.m_best.get(loc[i]);
                    if (best != null) {
                        return best;
                    }
                } else {
                    try {
                        best = this.loadObject(loc[i]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (best != null) {
                        return best;
                    }
                }
                ++i;
            }
        }
        return this.m_best.get(null);
    }

    public Locale getBestLocale(Enumeration locales) {
        Locale best = null;
        while (locales.hasMoreElements()) {
            Locale loc = (Locale)locales.nextElement();
            if (this.m_best.containsKey(loc)) {
                best = this.m_best.get(loc);
                if (best == null) continue;
                return best;
            }
            try {
                best = this.loadObject(loc);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (best == null) continue;
            return best;
        }
        return this.m_best.get(null);
    }

    private synchronized void registerObject(Object o, Locale locale) throws IOException {
        this.m_map.put(locale, o);
        this.m_best.put(locale, locale);
    }

    protected synchronized void loadDefaultFile() throws IOException {
        Locale locale = this.getDefaultLocale();
        Object o = this.rf.loadLocalObject(this.baseName, this.ext, null, locale);
        if (o == null) {
            throw new FileNotFoundException("Default file not found for " + this.baseName);
        }
        this.m_map.put(null, o);
        this.m_best.put(locale, null);
        this.m_best.put(null, locale);
    }

    public Locale getDefaultLocale() {
        return this.default_locale == null ? Locale.getDefault() : this.default_locale;
    }

    public void setDefaultLocale(Locale locale) {
        this.default_locale = locale;
        this.m_best.put(locale, null);
        this.m_best.put(null, locale);
    }

    private synchronized Locale loadObject(Locale locale) throws IOException {
        Object o;
        String localeName;
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        Locale bestLocale = locale;
        if (la != null) {
            if (va != null) {
                localeName = String.valueOf('_') + co + '_' + la + '_' + va;
                o = this.rf.loadLocalObject(this.baseName, this.ext, localeName, bestLocale);
                if (o != null) {
                    this.registerObject(o, bestLocale);
                    return bestLocale;
                }
                bestLocale = new Locale(co, la);
                if (this.m_map.containsKey(bestLocale)) {
                    o = this.m_map.get(bestLocale);
                    this.m_map.put(locale, o);
                    this.m_best.put(locale, bestLocale);
                    return bestLocale;
                }
            }
            if ((o = this.rf.loadLocalObject(this.baseName, this.ext, localeName = String.valueOf('_') + co + '_' + la, bestLocale)) != null) {
                this.registerObject(o, bestLocale);
                return bestLocale;
            }
            bestLocale = new Locale(co);
            if (this.m_map.containsKey(bestLocale)) {
                o = this.m_map.get(bestLocale);
                this.m_map.put(locale, o);
                this.m_best.put(locale, bestLocale);
                return bestLocale;
            }
        }
        if ((o = this.rf.loadLocalObject(this.baseName, this.ext, localeName = String.valueOf('_') + co, bestLocale)) != null) {
            this.registerObject(o, bestLocale);
        } else {
            this.m_best.put(locale, null);
            bestLocale = null;
        }
        return bestLocale;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

