/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.util.locale.LocaleNotFoundException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceCache {
    private Locale m_locale;
    private String baseclass;
    private Map<Locale, ResourceBundle> m_bundle;
    private Map<Locale, ResourceBundle> m_best = new HashMap<Locale, ResourceBundle>(6);
    private ClassLoader loader = null;

    ResourceCache(String baseclass) {
        this.m_bundle = new HashMap<Locale, ResourceBundle>(6);
        this.baseclass = baseclass;
    }

    public static ResourceCache createResourceCache(String baseclass, ClassLoader loader) {
        ResourceCache rmap = new ResourceCache(baseclass);
        rmap.loader = loader;
        Locale deflocale = Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(baseclass, deflocale, loader);
        rmap.m_locale = deflocale;
        rmap.m_best.put(deflocale, rb);
        rmap.m_bundle.put(deflocale, rb);
        return rmap;
    }

    public static ResourceCache createResourceCache(String baseclass) {
        return ResourceCache.createResourceCache(baseclass, ResourceCache.class.getClassLoader());
    }

    public ResourceBundle getBundle(Enumeration locales) {
        if (locales == null) {
            return this.getBundle();
        }
        ResourceBundle rb = null;
        while (locales.hasMoreElements()) {
            Locale loc = (Locale)locales.nextElement();
            if (!this.m_bundle.containsKey(loc)) {
                this.loadBestBundle(loc);
            }
            if ((rb = this.m_best.get(loc)) == null) continue;
            return rb;
        }
        if (rb == null) {
            rb = this.loadBestBundle(Locale.getDefault());
        }
        return rb;
    }

    public ResourceBundle getBundle(Locale[] loc) {
        if (loc == null) {
            return this.getBundle();
        }
        ResourceBundle rb = null;
        int i = 0;
        while (i < loc.length) {
            if (!this.m_bundle.containsKey(loc[i])) {
                this.loadBestBundle(loc[i]);
            }
            if ((rb = this.m_best.get(loc[i])) != null) {
                return rb;
            }
            ++i;
        }
        if (rb == null) {
            rb = this.loadBestBundle(loc[0]);
        }
        return rb;
    }

    public ResourceBundle getBundle(Locale loc) {
        ResourceBundle rb = this.m_best.get(loc);
        if (rb == null) {
            rb = this.loadBestBundle(loc);
        }
        return rb;
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.m_locale);
    }

    public Object getObject(String name) throws LocaleNotFoundException {
        return this.getObject(name, this.m_locale);
    }

    public String getString(String name) throws LocaleNotFoundException {
        return this.getString(name, this.m_locale);
    }

    public Object getObject(String name, Locale loc) throws MissingResourceException {
        return this.getBundle(loc).getObject(name);
    }

    public String getString(String name, Locale loc) throws MissingResourceException {
        return this.getBundle(loc).getString(name);
    }

    synchronized ResourceBundle loadBestBundle(Locale loc) {
        ResourceBundle rb;
        try {
            rb = ResourceBundle.getBundle(this.baseclass, loc, this.loader);
        }
        catch (MissingResourceException e) {
            return null;
        }
        Locale foundLocale = rb.getLocale();
        if (this.m_bundle.containsKey(foundLocale)) {
            if (this.m_locale.equals(foundLocale)) {
                if (this.m_locale.getLanguage().equals(loc.getLanguage())) {
                    this.m_best.put(loc, rb);
                } else {
                    this.m_best.put(loc, null);
                }
            } else {
                this.m_best.put(loc, this.m_bundle.get(foundLocale));
            }
        } else if (loc.equals(foundLocale)) {
            this.m_bundle.put(loc, rb);
            this.m_best.put(loc, rb);
        } else {
            this.m_best.put(loc, rb);
            this.m_bundle.put(loc, null);
            this.m_bundle.put(foundLocale, rb);
        }
        return rb;
    }
}

