/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.io.AssociationException;
import info.informatica.io.Associator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class ResourceFactory {
    private Associator assoc = null;
    static Logger log = Logger.getLogger((String)ResourceFactory.class.getName());

    public ResourceFactory() {
        this(new Associator());
    }

    public ResourceFactory(Associator assoc) {
        if (assoc == null) {
            throw new NullPointerException("Null associator");
        }
        this.assoc = assoc;
    }

    public Object loadLocalObject(String baseFileName, String ext, String localeName, Locale locale) throws IOException {
        InputStream is = this.loadLocalFile(baseFileName, ext, localeName);
        if (is == null) {
            return null;
        }
        URL url = new URL("file", null, baseFileName);
        Object o = this.instantiateObject(is, baseFileName, localeName, ext, locale, url);
        if (o != null) {
            is.close();
            return o;
        }
        return is;
    }

    protected Object instantiateObject(InputStream is, String baseFileName, String localeName, String ext, Locale locale, URL url) throws IOException {
        try {
            return this.assoc.create(is, url, ext);
        }
        catch (AssociationException e) {
            log.error((Object)("Cannot instantiate URL " + url.toString()), (Throwable)e);
            throw new IOException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.error((Object)("Cannot instantiate URL " + url.toString()), (Throwable)e);
            throw e;
        }
    }

    public abstract InputStream loadLocalFile(String var1, String var2, String var3) throws IOException;
}

