/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.InputLimitException;
import info.informatica.io.LimitedInputStream;
import info.informatica.io.LimitedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public final class LimitedInputFactory {
    private long g_maxsz;
    private static final long DEFAULT_MAX_GLOBAL_INPUT_SIZE = 0L;
    private long g_total = 0L;
    public boolean parar = false;

    public LimitedInputFactory() {
        this(0L);
    }

    public LimitedInputFactory(long max_global_size) {
        this.g_maxsz = max_global_size;
    }

    public LimitedInputStream getLimitedInputStream(InputStream is) {
        return this.createLimitedInputStream(is);
    }

    public LimitedInputStream createLimitedInputStream(InputStream is) {
        return new ExtendedLimitedInputStream(is);
    }

    public LimitedReader getLimitedReader(Reader re) {
        return this.createLimitedReader(re);
    }

    public LimitedReader createLimitedReader(Reader re) {
        return new ExtendedLimitedReader(re);
    }

    public long getBytesTransferred() {
        return this.g_total;
    }

    private final class ExtendedLimitedInputStream
    extends LimitedInputStream {
        public ExtendedLimitedInputStream(InputStream is, int maxsize) {
            super(is, maxsize);
        }

        public ExtendedLimitedInputStream(InputStream is) {
            this(is, 0x4000000);
        }

        public int write(OutputStream os) throws IOException {
            byte[] b = new byte[3000];
            int n = super.read(b);
            this.sumBytes(n);
            while (n != -1) {
                this.checkLimit();
                n = super.read(b);
                if (n != -1) {
                    os.write(b);
                    this.sumBytes(n);
                }
                if (LimitedInputFactory.this.parar) break;
            }
            return this.total;
        }

        protected void sumBytes(int n) {
            this.total += n;
            LimitedInputFactory limitedInputFactory = LimitedInputFactory.this;
            limitedInputFactory.g_total = limitedInputFactory.g_total + (long)n;
        }

        protected void checkLimit() {
            if (this.maxsz != 0 && this.total > this.maxsz || LimitedInputFactory.this.g_maxsz != 0L && LimitedInputFactory.this.g_total > LimitedInputFactory.this.g_maxsz) {
                throw new InputLimitException("Limit was exceeded!");
            }
        }
    }

    private final class ExtendedLimitedReader
    extends LimitedReader {
        public ExtendedLimitedReader(Reader re, int maxsize) {
            super(re, maxsize);
        }

        public ExtendedLimitedReader(Reader re) {
            super(re);
        }

        public String readAll(int filelen) throws IOException {
            char[] b = new char[4000];
            int n = super.read(b);
            StringBuffer content = filelen > 0 ? new StringBuffer(filelen) : new StringBuffer(8000);
            content.append(b, 0, n);
            this.sumBytes(n);
            while (n != -1) {
                this.checkLimit();
                n = super.read(b);
                if (n != -1) {
                    content.append(b, 0, n);
                    this.sumBytes(n);
                }
                if (LimitedInputFactory.this.parar) break;
            }
            return content.toString();
        }

        protected void sumBytes(int n) {
            this.total += n;
            LimitedInputFactory limitedInputFactory = LimitedInputFactory.this;
            limitedInputFactory.g_total = limitedInputFactory.g_total + (long)n;
        }

        protected void checkLimit() {
            if (this.maxsz != 0 && this.total > this.maxsz || LimitedInputFactory.this.g_maxsz != 0L && LimitedInputFactory.this.g_total > LimitedInputFactory.this.g_maxsz) {
                throw new InputLimitException("Limit was exceeded!");
            }
        }
    }
}

