/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.InputLimitException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LimitedReader
extends FilterReader {
    protected int maxsz;
    protected static final int DEFAULT_MAX_READER_SIZE = 0x400000;
    protected int total = 0;

    public LimitedReader(Reader re, int maxsize) {
        super(re);
        this.maxsz = maxsize;
    }

    public LimitedReader(Reader re) {
        this(re, 0x400000);
    }

    public String readAll() throws IOException {
        return this.readAll(0);
    }

    public String readAll(int filelen) throws IOException {
        char[] b = new char[4000];
        int n = super.read(b);
        StringBuffer content = filelen > 0 ? new StringBuffer(filelen) : new StringBuffer(8000);
        content.append(b, 0, n);
        this.sumBytes(n);
        while (n != -1) {
            this.checkLimit();
            n = super.read(b);
            if (n == -1) continue;
            content.append(b, 0, n);
            this.sumBytes(n);
        }
        return content.toString();
    }

    public int getBytesTransferred() {
        return this.total;
    }

    public int read() throws IOException {
        this.checkLimit();
        int i = super.read();
        if (i >= 0) {
            this.sumBytes(1);
        }
        return i;
    }

    public int read(char[] cbuf) throws IOException {
        this.checkLimit();
        int i = super.read(cbuf);
        this.sumBytes(i);
        return i;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkLimit();
        int i = super.read(cbuf, off, len);
        this.sumBytes(i);
        return i;
    }

    protected void sumBytes(int n) {
        this.total += n;
    }

    protected void checkLimit() {
        if (this.maxsz != 0 && this.total > this.maxsz) {
            throw new InputLimitException("Limit was exceeded!");
        }
    }
}

