/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

public class ServerConnectionException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String remoteAddr = null;
    protected String serverAddr = null;
    protected String serverName = null;

    public ServerConnectionException(String message) {
        super(message);
    }

    public ServerConnectionException(Throwable cause) {
        super(cause);
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer(7500);
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<server-error>\n");
        this.printConnectionInfo(sb);
        String msg = this.getMessage();
        Throwable t = this.getCause();
        if (msg == null && t != null) {
            msg = t.getMessage();
        }
        if (msg != null) {
            sb.append("\n  <error-message>\n    <![CDATA[\n    ").append(msg).append("\n    ]]>\n  </error-message>\n");
        }
        if (t != null) {
            StackTraceElement[] stack = t.getStackTrace();
            this.printXMLStackTrace(sb, stack);
        }
        return sb.toString();
    }

    protected void printConnectionInfo(StringBuffer sb) {
        if (this.serverAddr != null) {
            sb.append("  <remote-host>\n    ").append(this.serverAddr).append("\n  </remote-host>\n");
        }
        if (this.serverName != null) {
            sb.append("  <server-name>\n    ").append(this.serverName).append("\n  </server-name>\n");
        }
        if (this.remoteAddr != null) {
            sb.append("  <user-address>\n    ").append(this.remoteAddr).append("\n  </user-address>\n  ");
        }
    }

    public void printXMLStackTrace(StringBuffer sb, StackTraceElement[] stack) {
        if (stack.length == 0) {
            return;
        }
        sb.append("  <stack-trace>\n");
        int i = 0;
        while (i < stack.length) {
            sb.append("    <trace-element>\n      ").append(stack[i].toString()).append("\n    </trace-element>\n");
            ++i;
        }
        sb.append("  </stack-trace>\n");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1100);
        if (this.serverAddr != null) {
            sb.append("Remote host: ").append(this.serverAddr);
        }
        if (this.serverName != null) {
            sb.append("\nServer name:    ").append(this.serverName);
        }
        if (this.remoteAddr != null) {
            sb.append("\nUser Address: ").append(this.remoteAddr);
        }
        sb.append("\n\nMessage:\n").append(this.getMessage());
        return sb.toString();
    }

    public String getRemoteAddress() {
        return this.remoteAddr;
    }

    public void setRemoteAddress(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getServerAddress() {
        return this.serverAddr;
    }

    public void setServerAddress(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}

