/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatUtil {
    private DateFormat[] m_df = new DateFormat[11];
    private long DEFAULT_REFTIME;
    private static final long SANITY_INTERVAL = 631152000000L;

    public DateFormatUtil() {
        this.initDateFormats();
        this.DEFAULT_REFTIME = new Date().getTime();
    }

    private void initDateFormats() {
        this.m_df[0] = new SimpleDateFormat("dd-MM-yy");
        this.m_df[1] = new SimpleDateFormat("dd-MM-yyyy");
        this.m_df[2] = new SimpleDateFormat("dd/MM/yyyy");
        this.m_df[3] = new SimpleDateFormat("yyyy/MM/dd");
        this.m_df[4] = new SimpleDateFormat("yyyy-MM-dd");
        this.m_df[5] = new SimpleDateFormat("yy-MM-dd");
        this.m_df[6] = new SimpleDateFormat("yyyyMMdd");
        this.m_df[7] = new SimpleDateFormat("ddMMyyyy");
        this.m_df[8] = new SimpleDateFormat("dd-MMM-yyyy");
        this.m_df[9] = new SimpleDateFormat("dd/MMM/yyyy");
        this.m_df[10] = new SimpleDateFormat("yyyy/MMM/dd");
    }

    public Date guessDate(String formatted_date) {
        Date date = null;
        int i = 0;
        while (i >= 0 && i < this.m_df.length) {
            try {
                date = this.m_df[i].parse(formatted_date);
            }
            catch (ParseException e) {
                ++i;
                continue;
            }
            if (Math.abs(this.DEFAULT_REFTIME - date.getTime()) < 631152000000L) {
                i = -1;
                continue;
            }
            ++i;
        }
        return date;
    }

    public Date guessDate(Date refdate, String formatted_date) {
        Date date = null;
        long reftime = refdate.getTime();
        int i = 0;
        while (i >= 0 && i < this.m_df.length) {
            try {
                date = this.m_df[i].parse(formatted_date);
            }
            catch (ParseException e) {
                ++i;
                continue;
            }
            if (Math.abs(reftime - date.getTime()) < 631152000000L) {
                i = -1;
                continue;
            }
            ++i;
        }
        return date;
    }
}

