/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 2L;
    protected HashMap<Object, Long> lastacc;
    protected long t;

    public CacheMap() {
        this.lastacc = new HashMap();
        this.t = System.currentTimeMillis();
    }

    public CacheMap(int initialCapacity) {
        super(initialCapacity);
        this.lastacc = new HashMap(initialCapacity);
        this.t = System.currentTimeMillis();
    }

    public CacheMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.lastacc = new HashMap(initialCapacity, loadFactor);
        this.t = System.currentTimeMillis();
    }

    private CacheMap(Map<K, V> mapa, Map<Object, Long> lastacc, long t) {
        super(mapa);
        this.lastacc = new HashMap<Object, Long>(lastacc);
        this.t = t;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.lastacc.clear();
    }

    @Override
    public Object clone() {
        return new CacheMap<K, V>(this, this.lastacc, this.t);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        this.lastacc.put(key, new Long(System.currentTimeMillis() - this.t));
        return super.containsKey(key);
    }

    @Override
    public synchronized V get(Object key) {
        this.lastacc.put(key, new Long(System.currentTimeMillis() - this.t));
        return super.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        this.lastacc.put(key, new Long(System.currentTimeMillis() - this.t));
        return super.put(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        this.lastacc.remove(key);
        return super.remove(key);
    }

    public synchronized void expire(int exptime) {
        long texp = System.currentTimeMillis() - this.t - (long)exptime;
        if (texp < 0L) {
            return;
        }
        for (Map.Entry<Object, Long> me : this.lastacc.entrySet()) {
            Long ii = me.getValue();
            if ((long)ii.intValue() >= texp) continue;
            Object o = me.getKey();
            super.remove(o);
            this.lastacc.remove(o);
        }
    }
}

