/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.charset;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UTF8BOMTranslator {
    public static byte[] convert(byte[] bytes, String encout) throws Exception {
        int len;
        UnicodeInputStream uis = new UnicodeInputStream(new ByteArrayInputStream(bytes), "ASCII");
        boolean unicodeOutputReqd = UTF8BOMTranslator.getBOM(encout) != null;
        String enc = uis.getEncoding();
        String BOM = UTF8BOMTranslator.getBOM(enc);
        if (BOM == null) {
            BOM = UTF8BOMTranslator.getBOM(encout);
        }
        uis.close();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes, uis.getBOMOffset(), bytes.length), enc));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encout));
        if (BOM != null && unicodeOutputReqd) {
            w.write(BOM);
        }
        char[] buffer = new char[4096];
        while ((len = br.read(buffer)) != -1) {
            ((Writer)w).write(buffer, 0, len);
        }
        br.close();
        ((Writer)w).close();
        return out.toByteArray();
    }

    public static String getBOM(String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            byte[] bom = new byte[]{-17, -69, -65};
            return new String(bom, enc);
        }
        if ("UTF-16BE".equals(enc)) {
            byte[] bom = new byte[]{-2, -1};
            return new String(bom, enc);
        }
        if ("UTF-16LE".equals(enc)) {
            byte[] bom = new byte[]{-1, -2};
            return new String(bom, enc);
        }
        if ("UTF-32BE".equals(enc)) {
            byte[] bom = new byte[]{0, 0, -2, -1};
            return new String(bom, enc);
        }
        if ("UTF-32LE".equals(enc)) {
            byte[] bom = new byte[]{0, 0, -1, -2};
            return new String(bom, enc);
        }
        return null;
    }

    public static class UnicodeInputStream
    extends InputStream {
        private PushbackInputStream internalIn;
        private boolean isInited = false;
        private int BOMOffset = -1;
        private String defaultEnc;
        private String encoding;
        public static final int BOM_SIZE = 4;

        public UnicodeInputStream(InputStream in, String defaultEnc) {
            this.internalIn = new PushbackInputStream(in, 4);
            this.defaultEnc = defaultEnc;
        }

        public String getDefaultEncoding() {
            return this.defaultEnc;
        }

        public String getEncoding() {
            if (!this.isInited) {
                try {
                    this.init();
                }
                catch (IOException ex) {
                    IllegalStateException ise = new IllegalStateException("Init method failed.");
                    ise.initCause(ise);
                    throw ise;
                }
            }
            return this.encoding;
        }

        protected void init() throws IOException {
            int unread;
            if (this.isInited) {
                return;
            }
            byte[] bom = new byte[4];
            int n = this.internalIn.read(bom, 0, bom.length);
            if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                this.encoding = "UTF-32BE";
                unread = n - 4;
            } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                this.encoding = "UTF-32LE";
                unread = n - 4;
            } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                this.encoding = "UTF-8";
                unread = n - 3;
            } else if (bom[0] == -2 && bom[1] == -1) {
                this.encoding = "UTF-16BE";
                unread = n - 2;
            } else if (bom[0] == -1 && bom[1] == -2) {
                this.encoding = "UTF-16LE";
                unread = n - 2;
            } else {
                this.encoding = this.defaultEnc;
                unread = n;
            }
            this.BOMOffset = 4 - unread;
            if (unread > 0) {
                this.internalIn.unread(bom, n - unread, unread);
            }
            this.isInited = true;
        }

        public void close() throws IOException {
            this.isInited = true;
            this.internalIn.close();
        }

        public int read() throws IOException {
            this.isInited = true;
            return this.internalIn.read();
        }

        public int getBOMOffset() {
            return this.BOMOffset;
        }
    }
}

