/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.io.Associator;
import info.informatica.util.locale.ResourceFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileResourceFactory
extends ResourceFactory {
    public FileResourceFactory(Associator assoc) {
        super(assoc);
    }

    public FileResourceFactory() {
    }

    public InputStream loadLocalFile(String baseFileName, String ext, String localeName) throws IOException {
        InputStream is;
        StringBuffer fName = new StringBuffer(80).append(baseFileName);
        if (localeName != null) {
            fName.append(localeName);
        }
        if (ext != null) {
            fName.append('.').append(ext);
        }
        if ((is = this.openInputStream(fName.toString())) != null) {
            is = new BufferedInputStream(is);
            try {
                InputStream inputStream = FileResourceFactory.loadFile(is);
                return inputStream;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static InputStream loadFile(InputStream is) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        byte[] b = new byte[8192];
        while ((c = is.read(b)) != -1) {
            out.write(b, 0, c);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    protected InputStream openInputStream(String path) {
        FileInputStream is;
        File file = new File(path);
        this.setLastModified(file.lastModified());
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return is;
    }
}

