/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.util.locale.LocaleNotFoundException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public final class LocalProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Locale locale;

    public LocalProperties(Locale locale) {
        this.locale = locale;
    }

    public LocalProperties(Locale locale, Properties p) {
        super(p);
        this.locale = locale;
    }

    private LocalProperties(Locale locale, InputStream is) throws IOException {
        this.locale = locale;
        this.load(is);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static LocalProperties loadLocalProperties(String baseName, String ext) throws LocaleNotFoundException {
        return LocalProperties.loadBestLocalProperties(baseName, ext, Locale.getDefault());
    }

    public static LocalProperties loadBestLocalProperties(String baseName, String ext, Locale locale) throws LocaleNotFoundException {
        LocalProperties lp = LocalProperties.loadLocalProperties(baseName, ext, locale);
        if (lp != null) {
            return lp;
        }
        lp = LocalProperties.loadLocalProperties(baseName, ext, Locale.getDefault(), null);
        if (lp != null) {
            return lp;
        }
        throw new LocaleNotFoundException("Can't find localized file for base name " + baseName + '_' + locale.toString());
    }

    public static LocalProperties loadLocalProperties(String baseName, String ext, Locale locale) throws LocaleNotFoundException {
        String localeName;
        if (baseName == null) {
            throw new NullPointerException("baseName cannot be null");
        }
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        if (la != null) {
            LocalProperties lp;
            if (va != null && (lp = LocalProperties.loadLocalProperties(baseName, ext, locale, localeName = String.valueOf('_') + la + '_' + co + '_' + va)) != null) {
                return lp;
            }
            localeName = String.valueOf('_') + la + '_' + co;
            lp = LocalProperties.loadLocalProperties(baseName, ext, new Locale(la, co), localeName);
            if (lp != null) {
                return lp;
            }
        }
        localeName = String.valueOf('_') + la;
        return LocalProperties.loadLocalProperties(baseName, ext, new Locale(la), localeName);
    }

    private static LocalProperties loadLocalProperties(String baseFileName, String ext, Locale locale, String localeName) throws LocaleNotFoundException {
        BufferedInputStream is;
        StringBuffer fName = new StringBuffer(64).append(baseFileName);
        if (localeName != null) {
            fName.append(localeName);
        }
        if (ext != null) {
            fName.append('.').append(ext);
        }
        try {
            is = new BufferedInputStream(new FileInputStream(fName.toString()));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            LocalProperties localProperties = new LocalProperties(locale, is);
            return localProperties;
        }
        catch (IOException e) {
            throw new LocaleNotFoundException(e.getMessage());
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean check(String baseFileName, String ext) {
        StringBuffer fName = new StringBuffer(64).append(baseFileName);
        if (ext != null) {
            fName.append('.').append(ext);
        }
        File f = new File(fName.toString());
        return f.exists();
    }
}

