/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.io.Associator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public abstract class ResourceFactory {
    private Associator assoc = null;
    private long lastUpdate = 0L;

    public ResourceFactory() {
        this(new Associator());
    }

    public ResourceFactory(Associator assoc) {
        if (assoc == null) {
            throw new NullPointerException("Null associator");
        }
        this.assoc = assoc;
    }

    public long getLastModified() {
        return this.lastUpdate;
    }

    protected void setLastModified(long time) {
        this.lastUpdate = time;
    }

    protected InputStream readURL(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        URLConnection ucon = url.openConnection();
        ucon.connect();
        this.setLastModified(ucon.getLastModified());
        return ucon.getInputStream();
    }

    public Object loadLocalObject(String baseFileName, String ext, String localeName, Locale locale) throws IOException {
        InputStream is = this.loadLocalFile(baseFileName, ext, localeName);
        if (is == null) {
            return null;
        }
        URL url = new URL("file", null, baseFileName);
        Object o = this.instantiateObject(is, baseFileName, localeName, ext, locale, url);
        if (o != null) {
            is.close();
            return o;
        }
        return is;
    }

    protected Object instantiateObject(InputStream is, String baseFileName, String localeName, String ext, Locale locale, URL url) throws IOException {
        return this.assoc.create(is, url, ext);
    }

    public abstract InputStream loadLocalFile(String var1, String var2, String var3) throws IOException;
}

