/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.config.docgen;

import io.aeron.config.ConfigInfo;
import io.aeron.config.DefaultType;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class ConfigDocGenerator
implements AutoCloseable {
    private final FileWriter writer;

    static void generate(List<ConfigInfo> configInfoCollection, String outputFilename) throws Exception {
        try (ConfigDocGenerator generator = new ConfigDocGenerator(outputFilename);){
            generator.generateDoc(configInfoCollection);
        }
    }

    private ConfigDocGenerator(String outputFile) throws Exception {
        this.writer = new FileWriter(outputFile);
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void generateDoc(List<ConfigInfo> configInfoCollection) throws Exception {
        for (ConfigInfo configInfo : this.sort(configInfoCollection)) {
            this.writeHeader(this.toHeaderString(configInfo.id) + (configInfo.expectations.c.exists ? "" : " (***JAVA ONLY***)") + (configInfo.deprecated ? " (***DEPRECATED***)" : ""));
            this.write("Description", configInfo.propertyNameDescription);
            this.write("Type", (DefaultType.isUndefined(configInfo.overrideDefaultValueType) ? configInfo.defaultValueType : configInfo.overrideDefaultValueType).getSimpleName());
            this.writeCode("System Property", configInfo.propertyName);
            if (configInfo.context != null && !configInfo.context.isEmpty()) {
                this.writeCode("Context", configInfo.context);
            }
            if (configInfo.contextDescription != null && !configInfo.contextDescription.isEmpty()) {
                this.write("Context Description", configInfo.contextDescription);
            }
            if (configInfo.uriParam != null && !configInfo.uriParam.isEmpty()) {
                this.writeCode("URI Param", configInfo.uriParam);
            }
            if (configInfo.defaultDescription != null) {
                this.write("Default Description", configInfo.defaultDescription);
            }
            String defaultValue = configInfo.overrideDefaultValue == null ? (configInfo.defaultValue == null ? "" : configInfo.defaultValue) : configInfo.overrideDefaultValue;
            this.write("Default", this.getDefaultString(configInfo.defaultValueString == null ? defaultValue : configInfo.defaultValueString, configInfo.isTimeValue, configInfo.timeUnit));
            if (configInfo.isTimeValue == Boolean.TRUE) {
                this.write("Time Unit", configInfo.timeUnit.toString());
            }
            if (configInfo.expectations.c.exists) {
                this.writeCode("C Env Var", configInfo.expectations.c.envVar);
                this.write("C Default", this.getDefaultString(configInfo.expectations.c.defaultValue, configInfo.isTimeValue, configInfo.timeUnit));
            }
            this.writeLine();
        }
    }

    private List<ConfigInfo> sort(List<ConfigInfo> config) {
        return config.stream().sorted(Comparator.comparing(a -> a.id)).collect(Collectors.toList());
    }

    private void writeHeader(String t) throws IOException {
        this.writeRow("", t);
        this.writeLine();
        this.writeRow("---", "---");
        this.writeLine();
    }

    private void writeCode(String a, String b) throws IOException {
        this.write(a, "`" + b + "`");
    }

    private void write(String a, String b) throws IOException {
        this.writeRow("**" + a + "**", b.replaceAll("\n", " ").trim());
        this.writeLine();
    }

    private void writeLine() throws IOException {
        this.writer.write("\n");
    }

    private void writeRow(String a, String b) throws IOException {
        this.writer.write("| " + a + " | " + b + " |");
    }

    private String toHeaderString(String t) {
        StringBuilder builder = new StringBuilder();
        int previous = 95;
        for (int n : t.toCharArray()) {
            if (n == 95) {
                builder.append(' ');
            } else if (previous == 95) {
                builder.append(Character.toUpperCase((char)n));
            } else {
                builder.append(Character.toLowerCase((char)n));
            }
            previous = n;
        }
        return builder.toString();
    }

    private String getDefaultString(String defaultValue, boolean isTimeValue, TimeUnit timeUnit) throws Exception {
        if (defaultValue != null && !defaultValue.isEmpty() && defaultValue.chars().allMatch(Character::isDigit)) {
            long defaultLong;
            try {
                defaultLong = Long.parseLong(defaultValue);
            }
            catch (NumberFormatException nfe) {
                throw new Exception(nfe);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(defaultValue);
            if (defaultValue.length() > 3) {
                builder.append(" (");
                builder.append(DecimalFormat.getNumberInstance().format(defaultLong));
                builder.append(")");
                int kCount = 0;
                long remainingValue = defaultLong;
                while (remainingValue % 1024L == 0L) {
                    ++kCount;
                    remainingValue /= 1024L;
                }
                if (kCount > 0 && remainingValue < 1024L) {
                    builder.append(" (");
                    builder.append(remainingValue);
                    IntStream.range(0, kCount).forEach(i -> builder.append(" * 1024"));
                    builder.append(")");
                }
            }
            if (isTimeValue) {
                int tCount = 0;
                long remaining = timeUnit.toNanos(defaultLong);
                while (remaining % 1000L == 0L && tCount < 3) {
                    ++tCount;
                    remaining /= 1000L;
                }
                builder.append(" (");
                builder.append(remaining);
                switch (tCount) {
                    case 0: {
                        builder.append(" nano");
                        break;
                    }
                    case 1: {
                        builder.append(" micro");
                        break;
                    }
                    case 2: {
                        builder.append(" milli");
                        break;
                    }
                    case 3: {
                        builder.append(" ");
                    }
                }
                builder.append("second");
                if (remaining != 1L) {
                    builder.append("s");
                }
                builder.append(")");
            }
            return builder.toString();
        }
        return defaultValue;
    }
}

