/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Catalog;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import org.agrona.concurrent.UnsafeBuffer;

class ListRecordingByIdSession
implements Session {
    private final long correlationId;
    private final long recordingId;
    private final Catalog catalog;
    private final ControlSession controlSession;
    private final UnsafeBuffer descriptorBuffer;
    private boolean isDone;

    ListRecordingByIdSession(long correlationId, long recordingId, Catalog catalog, ControlSession controlSession, UnsafeBuffer descriptorBuffer) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.catalog = catalog;
        this.controlSession = controlSession;
        this.descriptorBuffer = descriptorBuffer;
    }

    @Override
    public void abort(String reason) {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public int doWork() {
        if (this.isDone) {
            return 0;
        }
        if (this.catalog.wrapDescriptor(this.recordingId, this.descriptorBuffer)) {
            if (this.controlSession.sendDescriptor(this.correlationId, this.descriptorBuffer)) {
                this.isDone = true;
            }
        } else {
            this.controlSession.sendRecordingUnknown(this.correlationId, this.recordingId);
            this.isDone = true;
        }
        return 1;
    }

    @Override
    public long sessionId() {
        return this.correlationId;
    }

    @Override
    public void close() {
        this.controlSession.activeListing(null);
    }
}

