/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.status.AtomicCounter;

public class ArchivingMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;

    ArchivingMediaDriver(MediaDriver driver, Archive archive) {
        this.driver = driver;
        this.archive = archive;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
             ArchivingMediaDriver ignore = ArchivingMediaDriver.launch(new MediaDriver.Context().terminationHook(() -> ((ShutdownSignalBarrier)barrier).signalAll()), new Archive.Context());){
            barrier.await();
            System.out.println("Shutdown Archive...");
        }
    }

    public static ArchivingMediaDriver launch() {
        return ArchivingMediaDriver.launch(new MediaDriver.Context(), new Archive.Context());
    }

    public static ArchivingMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx) {
        MediaDriver driver = null;
        Archive archive = null;
        try {
            driver = MediaDriver.launch((MediaDriver.Context)driverCtx);
            int errorCounterId = SystemCounterDescriptor.ERRORS.id();
            AtomicCounter errorCounter = null != archiveCtx.errorCounter() ? archiveCtx.errorCounter() : new AtomicCounter((AtomicBuffer)driverCtx.countersValuesBuffer(), errorCounterId);
            ErrorHandler errorHandler = null != archiveCtx.errorHandler() ? archiveCtx.errorHandler() : driverCtx.errorHandler();
            archive = Archive.launch(archiveCtx.mediaDriverAgentInvoker(driver.sharedAgentInvoker()).aeronDirectoryName(driverCtx.aeronDirectoryName()).errorHandler(errorHandler).errorCounter(errorCounter));
            return new ArchivingMediaDriver(driver, archive);
        }
        catch (Exception ex) {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{archive, driver});
            throw ex;
        }
    }

    public Archive archive() {
        return this.archive;
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    @Override
    public void close() {
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.archive, this.driver});
    }
}

