/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs.mark;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Mark file header.
 */
@SuppressWarnings("all")
public final class MarkFileHeaderEncoder
{
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 100;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final MarkFileHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public MarkFileHeaderEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public MarkFileHeaderEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int versionId()
    {
        return 1;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 0;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder version(final int value)
    {
        buffer.putInt(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int activityTimestampId()
    {
        return 2;
    }

    public static int activityTimestampSinceVersion()
    {
        return 0;
    }

    public static int activityTimestampEncodingOffset()
    {
        return 8;
    }

    public static int activityTimestampEncodingLength()
    {
        return 8;
    }

    public static String activityTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long activityTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long activityTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder activityTimestamp(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int startTimestampId()
    {
        return 3;
    }

    public static int startTimestampSinceVersion()
    {
        return 0;
    }

    public static int startTimestampEncodingOffset()
    {
        return 16;
    }

    public static int startTimestampEncodingLength()
    {
        return 8;
    }

    public static String startTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder startTimestamp(final long value)
    {
        buffer.putLong(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int pidId()
    {
        return 4;
    }

    public static int pidSinceVersion()
    {
        return 0;
    }

    public static int pidEncodingOffset()
    {
        return 24;
    }

    public static int pidEncodingLength()
    {
        return 8;
    }

    public static String pidMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long pidNullValue()
    {
        return -9223372036854775808L;
    }

    public static long pidMinValue()
    {
        return -9223372036854775807L;
    }

    public static long pidMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder pid(final long value)
    {
        buffer.putLong(offset + 24, value, BYTE_ORDER);
        return this;
    }


    public static int controlStreamIdId()
    {
        return 5;
    }

    public static int controlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int controlStreamIdEncodingOffset()
    {
        return 32;
    }

    public static int controlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String controlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int controlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int controlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int controlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder controlStreamId(final int value)
    {
        buffer.putInt(offset + 32, value, BYTE_ORDER);
        return this;
    }


    public static int localControlStreamIdId()
    {
        return 6;
    }

    public static int localControlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int localControlStreamIdEncodingOffset()
    {
        return 36;
    }

    public static int localControlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String localControlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int localControlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int localControlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int localControlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder localControlStreamId(final int value)
    {
        buffer.putInt(offset + 36, value, BYTE_ORDER);
        return this;
    }


    public static int eventsStreamIdId()
    {
        return 7;
    }

    public static int eventsStreamIdSinceVersion()
    {
        return 0;
    }

    public static int eventsStreamIdEncodingOffset()
    {
        return 40;
    }

    public static int eventsStreamIdEncodingLength()
    {
        return 4;
    }

    public static String eventsStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int eventsStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int eventsStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int eventsStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder eventsStreamId(final int value)
    {
        buffer.putInt(offset + 40, value, BYTE_ORDER);
        return this;
    }


    public static int headerLengthId()
    {
        return 8;
    }

    public static int headerLengthSinceVersion()
    {
        return 1;
    }

    public static int headerLengthEncodingOffset()
    {
        return 44;
    }

    public static int headerLengthEncodingLength()
    {
        return 4;
    }

    public static String headerLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int headerLengthNullValue()
    {
        return 0;
    }

    public static int headerLengthMinValue()
    {
        return -2147483647;
    }

    public static int headerLengthMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder headerLength(final int value)
    {
        buffer.putInt(offset + 44, value, BYTE_ORDER);
        return this;
    }


    public static int errorBufferLengthId()
    {
        return 9;
    }

    public static int errorBufferLengthSinceVersion()
    {
        return 1;
    }

    public static int errorBufferLengthEncodingOffset()
    {
        return 48;
    }

    public static int errorBufferLengthEncodingLength()
    {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int errorBufferLengthNullValue()
    {
        return 0;
    }

    public static int errorBufferLengthMinValue()
    {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder errorBufferLength(final int value)
    {
        buffer.putInt(offset + 48, value, BYTE_ORDER);
        return this;
    }


    public static int archiveIdId()
    {
        return 14;
    }

    public static int archiveIdSinceVersion()
    {
        return 2;
    }

    public static int archiveIdEncodingOffset()
    {
        return 56;
    }

    public static int archiveIdEncodingLength()
    {
        return 8;
    }

    public static String archiveIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static long archiveIdNullValue()
    {
        return -1L;
    }

    public static long archiveIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long archiveIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder archiveId(final long value)
    {
        buffer.putLong(offset + 56, value, BYTE_ORDER);
        return this;
    }


    public static int controlChannelId()
    {
        return 10;
    }

    public static String controlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String controlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int controlChannelHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putControlChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putControlChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder controlChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder controlChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int localControlChannelId()
    {
        return 11;
    }

    public static String localControlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String localControlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int localControlChannelHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putLocalControlChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putLocalControlChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder localControlChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder localControlChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int eventsChannelId()
    {
        return 12;
    }

    public static String eventsChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String eventsChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int eventsChannelHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putEventsChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putEventsChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder eventsChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder eventsChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int aeronDirectoryId()
    {
        return 13;
    }

    public static String aeronDirectoryCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String aeronDirectoryMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int aeronDirectoryHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putAeronDirectory(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putAeronDirectory(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
