/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.exceptions.ConfigurationException;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class AeronCounters {
    public static final int SYSTEM_COUNTER_ID_BYTES_SENT = 0;
    public static final int SYSTEM_COUNTER_ID_BYTES_RECEIVED = 1;
    public static final int SYSTEM_COUNTER_ID_RECEIVER_PROXY_FAILS = 2;
    public static final int SYSTEM_COUNTER_ID_SENDER_PROXY_FAILS = 3;
    public static final int SYSTEM_COUNTER_ID_CONDUCTOR_PROXY_FAILS = 4;
    public static final int SYSTEM_COUNTER_ID_NAK_MESSAGES_SENT = 5;
    public static final int SYSTEM_COUNTER_ID_NAK_MESSAGES_RECEIVED = 6;
    public static final int SYSTEM_COUNTER_ID_STATUS_MESSAGES_SENT = 7;
    public static final int SYSTEM_COUNTER_ID_STATUS_MESSAGES_RECEIVED = 8;
    public static final int SYSTEM_COUNTER_ID_HEARTBEATS_SENT = 9;
    public static final int SYSTEM_COUNTER_ID_HEARTBEATS_RECEIVED = 10;
    public static final int SYSTEM_COUNTER_ID_RETRANSMITS_SENT = 11;
    public static final int SYSTEM_COUNTER_ID_FLOW_CONTROL_UNDER_RUNS = 12;
    public static final int SYSTEM_COUNTER_ID_FLOW_CONTROL_OVER_RUNS = 13;
    public static final int SYSTEM_COUNTER_ID_INVALID_PACKETS = 14;
    public static final int SYSTEM_COUNTER_ID_ERRORS = 15;
    public static final int SYSTEM_COUNTER_ID_SHORT_SENDS = 16;
    public static final int SYSTEM_COUNTER_ID_FREE_FAILS = 17;
    public static final int SYSTEM_COUNTER_ID_SENDER_FLOW_CONTROL_LIMITS = 18;
    public static final int SYSTEM_COUNTER_ID_UNBLOCKED_PUBLICATIONS = 19;
    public static final int SYSTEM_COUNTER_ID_UNBLOCKED_COMMANDS = 20;
    public static final int SYSTEM_COUNTER_ID_POSSIBLE_TTL_ASYMMETRY = 21;
    public static final int SYSTEM_COUNTER_ID_CONTROLLABLE_IDLE_STRATEGY = 22;
    public static final int SYSTEM_COUNTER_ID_LOSS_GAP_FILLS = 23;
    public static final int SYSTEM_COUNTER_ID_CLIENT_TIMEOUTS = 24;
    public static final int SYSTEM_COUNTER_ID_RESOLUTION_CHANGES = 25;
    public static final int SYSTEM_COUNTER_ID_CONDUCTOR_MAX_CYCLE_TIME = 26;
    public static final int SYSTEM_COUNTER_ID_CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED = 27;
    public static final int SYSTEM_COUNTER_ID_SENDER_MAX_CYCLE_TIME = 28;
    public static final int SYSTEM_COUNTER_ID_SENDER_CYCLE_TIME_THRESHOLD_EXCEEDED = 29;
    public static final int SYSTEM_COUNTER_ID_RECEIVER_MAX_CYCLE_TIME = 30;
    public static final int SYSTEM_COUNTER_ID_RECEIVER_CYCLE_TIME_THRESHOLD_EXCEEDED = 31;
    public static final int SYSTEM_COUNTER_ID_NAME_RESOLVER_MAX_TIME = 32;
    public static final int SYSTEM_COUNTER_ID_NAME_RESOLVER_TIME_THRESHOLD_EXCEEDED = 33;
    public static final int SYSTEM_COUNTER_ID_AERON_VERSION = 34;
    public static final int SYSTEM_COUNTER_ID_BYTES_CURRENTLY_MAPPED = 35;
    public static final int SYSTEM_COUNTER_ID_RETRANSMITTED_BYTES = 36;
    public static final int SYSTEM_COUNTER_ID_RETRANSMIT_OVERFLOW = 37;
    public static final int SYSTEM_COUNTER_ID_ERROR_FRAMES_RECEIVED = 38;
    public static final int SYSTEM_COUNTER_ID_ERROR_FRAMES_SENT = 39;
    public static final int SYSTEM_COUNTER_ID_PUBLICATIONS_REVOKED = 40;
    public static final int SYSTEM_COUNTER_ID_PUBLICATION_IMAGES_REVOKED = 41;
    public static final int SYSTEM_COUNTER_ID_IMAGES_REJECTED = 42;
    public static final int SYSTEM_COUNTER_ID_CONTROL_PROTOCOL_VERSION = 43;
    public static final int DRIVER_SYSTEM_COUNTER_TYPE_ID = 0;
    public static final int DRIVER_PUBLISHER_LIMIT_TYPE_ID = 1;
    public static final int DRIVER_SENDER_POSITION_TYPE_ID = 2;
    public static final int DRIVER_RECEIVER_HWM_TYPE_ID = 3;
    public static final int DRIVER_SUBSCRIBER_POSITION_TYPE_ID = 4;
    public static final int DRIVER_RECEIVER_POS_TYPE_ID = 5;
    public static final int DRIVER_SEND_CHANNEL_STATUS_TYPE_ID = 6;
    public static final int DRIVER_RECEIVE_CHANNEL_STATUS_TYPE_ID = 7;
    public static final int DRIVER_SENDER_LIMIT_TYPE_ID = 9;
    public static final int DRIVER_PER_IMAGE_TYPE_ID = 10;
    public static final int DRIVER_HEARTBEAT_TYPE_ID = 11;
    public static final int DRIVER_PUBLISHER_POS_TYPE_ID = 12;
    public static final int DRIVER_SENDER_BPE_TYPE_ID = 13;
    public static final int NAME_RESOLVER_NEIGHBORS_COUNTER_TYPE_ID = 15;
    public static final int NAME_RESOLVER_CACHE_ENTRIES_COUNTER_TYPE_ID = 16;
    public static final int DRIVER_LOCAL_SOCKET_ADDRESS_STATUS_TYPE_ID = 14;
    public static final int FLOW_CONTROL_RECEIVERS_COUNTER_TYPE_ID = 17;
    public static final int MDC_DESTINATIONS_COUNTER_TYPE_ID = 18;
    public static final int DRIVER_SENDER_NAKS_RECEIVED_TYPE_ID = 19;
    public static final int DRIVER_RECEIVER_NAKS_SENT_TYPE_ID = 20;
    public static final int ARCHIVE_RECORDING_POSITION_TYPE_ID = 100;
    public static final int ARCHIVE_ERROR_COUNT_TYPE_ID = 101;
    public static final int ARCHIVE_CONTROL_SESSIONS_TYPE_ID = 102;
    public static final int ARCHIVE_MAX_CYCLE_TIME_TYPE_ID = 103;
    public static final int ARCHIVE_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 104;
    public static final int ARCHIVE_RECORDER_MAX_WRITE_TIME_TYPE_ID = 105;
    public static final int ARCHIVE_RECORDER_TOTAL_WRITE_BYTES_TYPE_ID = 106;
    public static final int ARCHIVE_RECORDER_TOTAL_WRITE_TIME_TYPE_ID = 107;
    public static final int ARCHIVE_REPLAYER_MAX_READ_TIME_TYPE_ID = 108;
    public static final int ARCHIVE_REPLAYER_TOTAL_READ_BYTES_TYPE_ID = 109;
    public static final int ARCHIVE_REPLAYER_TOTAL_READ_TIME_TYPE_ID = 110;
    public static final int ARCHIVE_RECORDING_SESSION_COUNT_TYPE_ID = 111;
    public static final int ARCHIVE_REPLAY_SESSION_COUNT_TYPE_ID = 112;
    public static final int ARCHIVE_CONTROL_SESSION_TYPE_ID = 113;
    public static final int CLUSTER_CONSENSUS_MODULE_STATE_TYPE_ID = 200;
    public static final int CLUSTER_NODE_ROLE_TYPE_ID = 201;
    public static final int CLUSTER_CONTROL_TOGGLE_TYPE_ID = 202;
    public static final int CLUSTER_COMMIT_POSITION_TYPE_ID = 203;
    public static final int CLUSTER_RECOVERY_STATE_TYPE_ID = 204;
    public static final int CLUSTER_SNAPSHOT_COUNTER_TYPE_ID = 205;
    public static final int CLUSTER_ELECTION_STATE_TYPE_ID = 207;
    public static final int CLUSTER_BACKUP_STATE_TYPE_ID = 208;
    public static final int CLUSTER_BACKUP_LIVE_LOG_POSITION_TYPE_ID = 209;
    public static final int CLUSTER_BACKUP_QUERY_DEADLINE_TYPE_ID = 210;
    public static final int CLUSTER_BACKUP_ERROR_COUNT_TYPE_ID = 211;
    public static final int CLUSTER_CONSENSUS_MODULE_ERROR_COUNT_TYPE_ID = 212;
    public static final int CLUSTER_CLIENT_TIMEOUT_COUNT_TYPE_ID = 213;
    public static final int CLUSTER_INVALID_REQUEST_COUNT_TYPE_ID = 214;
    public static final int CLUSTER_CLUSTERED_SERVICE_ERROR_COUNT_TYPE_ID = 215;
    public static final int CLUSTER_MAX_CYCLE_TIME_TYPE_ID = 216;
    public static final int CLUSTER_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 217;
    public static final int CLUSTER_CLUSTERED_SERVICE_MAX_CYCLE_TIME_TYPE_ID = 218;
    public static final int CLUSTER_CLUSTERED_SERVICE_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 219;
    public static final int CLUSTER_STANDBY_STATE_TYPE_ID = 220;
    public static final int CLUSTER_STANDBY_ERROR_COUNT_TYPE_ID = 221;
    public static final int CLUSTER_STANDBY_HEARTBEAT_RESPONSE_COUNT_TYPE_ID = 222;
    public static final int CLUSTER_STANDBY_CONTROL_TOGGLE_TYPE_ID = 223;
    public static final int TRANSITION_MODULE_STATE_TYPE_ID = 224;
    public static final int TRANSITION_MODULE_CONTROL_TOGGLE_TYPE_ID = 225;
    public static final int TRANSITION_MODULE_ERROR_COUNT_TYPE_ID = 226;
    public static final int CLUSTER_STANDBY_MAX_CYCLE_TIME_TYPE_ID = 227;
    public static final int CLUSTER_STANDBY_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 228;
    public static final int TRANSITION_MODULE_MAX_CYCLE_TIME_TYPE_ID = 229;
    public static final int TRANSITION_MODULE_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 230;
    public static final int CLUSTER_STANDBY_SOURCE_MEMBER_ID_TYPE_ID = 231;
    public static final int CLUSTER_STANDBY_SNAPSHOT_COUNTER_TYPE_ID = 232;
    public static final int NODE_CONTROL_TOGGLE_TYPE_ID = 233;
    public static final int CLUSTER_TOTAL_MAX_SNAPSHOT_DURATION_TYPE_ID = 234;
    public static final int CLUSTER_TOTAL_SNAPSHOT_DURATION_THRESHOLD_EXCEEDED_TYPE_ID = 235;
    public static final int CLUSTERED_SERVICE_MAX_SNAPSHOT_DURATION_TYPE_ID = 236;
    public static final int CLUSTERED_SERVICE_SNAPSHOT_DURATION_THRESHOLD_EXCEEDED_TYPE_ID = 237;
    public static final int CLUSTER_ELECTION_COUNT_TYPE_ID = 238;
    public static final int CLUSTER_LEADERSHIP_TERM_ID_TYPE_ID = 239;
    public static final int CLUSTER_BACKUP_SNAPSHOT_RETRIEVE_COUNT_TYPE_ID = 240;
    public static final int CLUSTER_SESSION_TYPE_ID = 241;
    public static final int SEQUENCER_INDEX_COUNTER_TYPE_ID = 500;
    public static final int SEQUENCER_GROUP_HWM_COUNTER_TYPE_ID = 501;
    public static final int SEQUENCER_SESSION_GREATEST_MESSAGE_ID_COUNTER_TYPE_ID = 502;
    public static final int SEQUENCER_SESSION_MESSAGES_COUNTER_TYPE_ID = 503;
    public static final int SEQUENCER_SESSION_GREATEST_MESSAGE_TIMESTAMP_COUNTER_TYPE_ID = 504;
    public static final int SEQUENCER_CLIENT_SNAPSHOT_ID_COUNTER_TYPE_ID = 505;
    public static final int SEQUENCER_APPLICATION_SEQUENCE_INDEX_COUNTER_TYPE_ID = 507;
    public static final int SEQUENCER_APPLICATION_STATE_COUNTER_TYPE_ID = 508;
    public static final int SEQUENCER_APPLICATION_ERROR_COUNT_TYPE_ID = 509;
    public static final int SEQUENCER_APPLICATION_MAX_SERVICE_TIME_TYPE_ID = 510;
    public static final int SEQUENCER_APPLICATION_SERVICE_TIME_THRESHOLD_EXCEEDED_COUNT_TYPE_ID = 511;
    public static final int SEQUENCER_APPLICATION_INTERVAL_SERVICE_TIME_TYPE_ID = 512;
    public static final int SEQUENCER_APPLICATION_INTERVAL_MAX_SERVICE_TIME_TYPE_ID = 513;
    public static final int SEQUENCER_APPLICATION_INTERVAL_TOTAL_INVOCATIONS_TYPE_ID = 514;
    public static final int SEQUENCER_APPLICATION_SNAPSHOT_LOAD_TIME_TYPE_ID = 515;
    public static final int SEQUENCER_APPLICATION_SNAPSHOT_STORE_TIME_TYPE_ID = 516;
    public static final int SEQUENCER_APPLICATION_TAKE_SNAPSHOT_FAILURES_TYPE_ID = 517;
    public static final int SEQUENCER_APPLICATION_TAKE_SNAPSHOT_COUNT_TYPE_ID = 518;
    public static final int SEQUENCER_APPLICATION_SESSION_ID_TYPE_ID = 519;
    public static final int SEQUENCER_REPLAY_INDEX_MIN_SEQUENCE_INDEX_COUNTER_TYPE_ID = 520;
    public static final int SEQUENCER_REPLAY_INDEX_MIN_SEQUENCE_LOG_POSITION_COUNTER_TYPE_ID = 521;
    public static final int SEQUENCER_REPLAY_INDEX_MAX_SEQUENCE_INDEX_COUNTER_TYPE_ID = 522;
    public static final int SEQUENCER_REPLAY_INDEX_MAX_SEQUENCE_LOG_POSITION_COUNTER_TYPE_ID = 523;
    public static final int SEQUENCER_REPLAY_INDEX_INITIAL_SEQUENCE_INDEX_COUNTER_TYPE_ID = 524;
    public static final int SEQUENCER_REPLAY_INDEX_INITIAL_SEQUENCE_LOG_POSITION_COUNTER_TYPE_ID = 525;

    private AeronCounters() {
    }

    public static void validateCounterTypeId(CountersReader countersReader, int counterId, int expectedCounterTypeId) {
        int counterTypeId = countersReader.getCounterTypeId(counterId);
        if (expectedCounterTypeId != counterTypeId) {
            throw new ConfigurationException("The type for counterId=" + counterId + ", typeId=" + counterTypeId + " does not match the expected=" + expectedCounterTypeId);
        }
    }

    public static void validateCounterTypeId(Aeron aeron, Counter counter, int expectedCounterTypeId) {
        AeronCounters.validateCounterTypeId(aeron.countersReader(), counter.id(), expectedCounterTypeId);
    }

    public static int appendVersionInfo(MutableDirectBuffer tempBuffer, int offset, String fullVersion, String commitHashCode) {
        int length = tempBuffer.putStringWithoutLengthAscii(offset, " ");
        length += tempBuffer.putStringWithoutLengthAscii(offset + length, AeronCounters.formatVersionInfo(fullVersion, commitHashCode));
        return length;
    }

    public static int appendToLabel(AtomicBuffer metaDataBuffer, int counterId, String value) {
        int remainingLabelLength;
        Objects.requireNonNull(metaDataBuffer);
        AeronCounters.validateCounterId(metaDataBuffer, counterId);
        int counterMetaDataOffset = CountersReader.metaDataOffset((int)counterId);
        int state = metaDataBuffer.getIntVolatile(counterMetaDataOffset);
        if (1 != state) {
            throw new IllegalArgumentException("counter id " + counterId + " is not allocated, state: " + state);
        }
        int existingLabelLength = metaDataBuffer.getInt(counterMetaDataOffset + 128);
        int writtenLength = metaDataBuffer.putStringWithoutLengthAscii(counterMetaDataOffset + 128 + 4 + existingLabelLength, value, 0, remainingLabelLength = 380 - existingLabelLength);
        if (writtenLength > 0) {
            metaDataBuffer.putIntRelease(counterMetaDataOffset + 128, existingLabelLength + writtenLength);
        }
        return writtenLength;
    }

    public static String formatVersionInfo(String fullVersion, String commitHash) {
        return "version=" + fullVersion + " commit=" + commitHash;
    }

    public static void setReferenceId(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, int counterId, long referenceId) {
        Objects.requireNonNull(metaDataBuffer);
        Objects.requireNonNull(valuesBuffer);
        AeronCounters.validateCounterId(metaDataBuffer, counterId);
        valuesBuffer.putLongRelease(CountersReader.counterOffset((int)counterId) + 24, referenceId);
    }

    private static void validateCounterId(AtomicBuffer metaDataBuffer, int counterId) {
        if (counterId < 0) {
            throw new IllegalArgumentException("counter id " + counterId + " is negative");
        }
        int maxCounterId = metaDataBuffer.capacity() / 512 - 1;
        if (counterId > maxCounterId) {
            throw new IllegalArgumentException("counter id " + counterId + " out of range: 0 - maxCounterId=" + maxCounterId);
        }
    }
}

