/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.exceptions.AeronException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.UnsafeBuffer;

public class CncFileDescriptor {
    public static final String CNC_FILE = "cnc.dat";
    public static final int CNC_VERSION = SemanticVersion.compose((int)0, (int)2, (int)0);
    public static final int CNC_VERSION_FIELD_OFFSET = 0;
    public static final int TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET = CNC_VERSION_FIELD_OFFSET + 4;
    public static final int TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET = TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET = TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    public static final int ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    public static final int START_TIMESTAMP_FIELD_OFFSET;
    public static final int PID_FIELD_OFFSET;
    public static final int FILE_PAGE_SIZE_FIELD_OFFSET;
    public static final int META_DATA_LENGTH = 128;
    public static final int END_OF_METADATA_OFFSET = 128;

    public static int computeCncFileLength(int totalLengthOfBuffers, int alignment) {
        return BitUtil.align((int)(128 + totalLengthOfBuffers), (int)alignment);
    }

    public static int cncVersionOffset(int baseOffset) {
        return baseOffset + CNC_VERSION_FIELD_OFFSET;
    }

    public static int toDriverBufferLengthOffset(int baseOffset) {
        return baseOffset + TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int toClientsBufferLengthOffset(int baseOffset) {
        return baseOffset + TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersMetaDataBufferLengthOffset(int baseOffset) {
        return baseOffset + COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersValuesBufferLengthOffset(int baseOffset) {
        return baseOffset + COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int clientLivenessTimeoutOffset(int baseOffset) {
        return baseOffset + CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    }

    public static int errorLogBufferLengthOffset(int baseOffset) {
        return baseOffset + ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int startTimestampOffset(int baseOffset) {
        return baseOffset + START_TIMESTAMP_FIELD_OFFSET;
    }

    public static int pidOffset(int baseOffset) {
        return baseOffset + PID_FIELD_OFFSET;
    }

    public static void fillMetaData(UnsafeBuffer cncMetaDataBuffer, int toDriverBufferLength, int toClientsBufferLength, int counterMetaDataBufferLength, int counterValuesBufferLength, long clientLivenessTimeoutNs, int errorLogBufferLength, long startTimestampMs, long pid, int filePageSize) {
        cncMetaDataBuffer.putInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET, toDriverBufferLength);
        cncMetaDataBuffer.putInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET, toClientsBufferLength);
        cncMetaDataBuffer.putInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET, counterMetaDataBufferLength);
        cncMetaDataBuffer.putInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET, counterValuesBufferLength);
        cncMetaDataBuffer.putInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET, errorLogBufferLength);
        cncMetaDataBuffer.putLong(CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET, clientLivenessTimeoutNs);
        cncMetaDataBuffer.putLong(START_TIMESTAMP_FIELD_OFFSET, startTimestampMs);
        cncMetaDataBuffer.putLong(PID_FIELD_OFFSET, pid);
        cncMetaDataBuffer.putInt(FILE_PAGE_SIZE_FIELD_OFFSET, filePageSize);
    }

    public static void signalCncReady(UnsafeBuffer cncMetaDataBuffer) {
        cncMetaDataBuffer.putIntVolatile(CNC_VERSION_FIELD_OFFSET, CNC_VERSION);
    }

    public static UnsafeBuffer createMetaDataBuffer(ByteBuffer buffer) {
        return new UnsafeBuffer(buffer, 0, 128);
    }

    public static UnsafeBuffer createToDriverBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        return new UnsafeBuffer(buffer, 128, metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET));
    }

    public static UnsafeBuffer createToClientsBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = 128 + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET);
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET));
    }

    public static UnsafeBuffer createCountersMetaDataBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = 128 + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET);
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET));
    }

    public static UnsafeBuffer createCountersValuesBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = 128 + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET);
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET));
    }

    public static UnsafeBuffer createErrorLogBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = 128 + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET);
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET));
    }

    public static long clientLivenessTimeoutNs(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET);
    }

    public static long startTimestampMs(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(START_TIMESTAMP_FIELD_OFFSET);
    }

    public static long pid(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(PID_FIELD_OFFSET);
    }

    public static int filePageSize(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getInt(FILE_PAGE_SIZE_FIELD_OFFSET);
    }

    public static void checkVersion(int cncVersion) {
        if (SemanticVersion.major((int)CNC_VERSION) != SemanticVersion.major((int)cncVersion)) {
            throw new AeronException("CnC version not compatible: app=" + SemanticVersion.toString((int)CNC_VERSION) + " file=" + SemanticVersion.toString((int)cncVersion));
        }
    }

    public static boolean isCncFileLengthSufficient(DirectBuffer metaDataBuffer, int cncFileLength) {
        int metadataRequiredLength = 128 + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET);
        return cncFileLength >= metadataRequiredLength;
    }

    public static boolean isCncFile(Path path, BasicFileAttributes ignored) {
        return path.getFileName().toString().equals(CNC_FILE);
    }

    static {
        ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET + 4;
        CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET = ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET + 4;
        START_TIMESTAMP_FIELD_OFFSET = CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET + 8;
        PID_FIELD_OFFSET = START_TIMESTAMP_FIELD_OFFSET + 8;
        FILE_PAGE_SIZE_FIELD_OFFSET = PID_FIELD_OFFSET + 8;
    }
}

