/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.LogBuffers;
import io.aeron.Subscription;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.logbuffer.TermBlockScanner;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;

public final class Image {
    private final long correlationId;
    private final long joinPosition;
    private final int sessionId;
    private final int initialTermId;
    private final int termLengthMask;
    private final int positionBitsToShift;
    private final int mtu;
    private long finalPosition;
    private long eosPosition = Long.MAX_VALUE;
    private boolean isEos;
    private boolean isRevoked;
    private volatile boolean isClosed;
    private final Position subscriberPosition;
    private final UnsafeBuffer[] termBuffers;
    private final Header header;
    private final ErrorHandler errorHandler;
    private final LogBuffers logBuffers;
    private final String sourceIdentity;
    private final Subscription subscription;

    public Image(Subscription subscription, int sessionId, Position subscriberPosition, LogBuffers logBuffers, ErrorHandler errorHandler, String sourceIdentity, long correlationId) {
        this.subscription = subscription;
        this.sessionId = sessionId;
        this.subscriberPosition = subscriberPosition;
        this.logBuffers = logBuffers;
        this.errorHandler = errorHandler;
        this.sourceIdentity = sourceIdentity;
        this.correlationId = correlationId;
        this.joinPosition = subscriberPosition.get();
        this.termBuffers = logBuffers.duplicateTermBuffers();
        int termLength = logBuffers.termLength();
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.initialTermId = LogBufferDescriptor.initialTermId(logBuffers.metaDataBuffer());
        this.mtu = LogBufferDescriptor.mtuLength(logBuffers.metaDataBuffer());
        this.header = new Header(this.initialTermId, this.positionBitsToShift, this);
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int termBufferLength() {
        return this.termLengthMask + 1;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    public int mtuLength() {
        return this.mtu;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long joinPosition() {
        return this.joinPosition;
    }

    public long position() {
        if (this.isClosed) {
            return this.finalPosition;
        }
        return this.subscriberPosition.get();
    }

    public void position(long newPosition) {
        if (!this.isClosed) {
            this.validatePosition(newPosition);
            this.subscriberPosition.setRelease(newPosition);
        }
    }

    public int subscriberPositionId() {
        return this.subscriberPosition.id();
    }

    public boolean isEndOfStream() {
        if (this.isClosed) {
            return this.isEos;
        }
        return this.subscriberPosition.get() >= LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
    }

    public long endOfStreamPosition() {
        if (this.isClosed) {
            return this.eosPosition;
        }
        return LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
    }

    public int activeTransportCount() {
        if (this.isClosed) {
            return 0;
        }
        return LogBufferDescriptor.activeTransportCount(this.logBuffers.metaDataBuffer());
    }

    public boolean isPublicationRevoked() {
        if (this.isClosed) {
            return this.isRevoked;
        }
        return LogBufferDescriptor.isPublicationRevoked(this.logBuffers.metaDataBuffer());
    }

    public FileChannel fileChannel() {
        return this.logBuffers.fileChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int initialOffset;
        if (this.isClosed) {
            return 0;
        }
        int fragmentsRead = 0;
        long initialPosition = this.subscriberPosition.get();
        int offset = initialOffset = (int)initialPosition & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int capacity = termBuffer.capacity();
        Header header = this.header;
        header.buffer((DirectBuffer)termBuffer);
        try {
            while (fragmentsRead < fragmentLimit && offset < capacity && !this.isClosed) {
                int frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset);
                if (frameLength <= 0) {
                    break;
                }
                int frameOffset = offset;
                offset += BitUtil.align((int)frameLength, (int)32);
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                fragmentHandler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, frameLength - 32, header);
            }
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        finally {
            long newPosition = initialPosition + (long)(offset - initialOffset);
            if (newPosition > initialPosition && !this.isClosed) {
                this.subscriberPosition.setRelease(newPosition);
            }
        }
        return fragmentsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int controlledPoll(ControlledFragmentHandler handler, int fragmentLimit) {
        int initialOffset;
        if (this.isClosed) {
            return 0;
        }
        int fragmentsRead = 0;
        long initialPosition = this.subscriberPosition.get();
        int offset = initialOffset = (int)initialPosition & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int capacity = termBuffer.capacity();
        Header header = this.header;
        header.buffer((DirectBuffer)termBuffer);
        try {
            while (fragmentsRead < fragmentLimit && offset < capacity && !this.isClosed) {
                int length = FrameDescriptor.frameLengthVolatile(termBuffer, offset);
                if (length <= 0) {
                    break;
                }
                int frameOffset = offset;
                int alignedLength = BitUtil.align((int)length, (int)32);
                offset += alignedLength;
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                ControlledFragmentHandler.Action action = handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, length - 32, header);
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    --fragmentsRead;
                    offset -= alignedLength;
                    break;
                }
                if (ControlledFragmentHandler.Action.BREAK == action) {
                    break;
                }
                if (ControlledFragmentHandler.Action.COMMIT != action) continue;
                initialPosition += (long)(offset - initialOffset);
                initialOffset = offset;
                if (this.isClosed) continue;
                this.subscriberPosition.setRelease(initialPosition);
            }
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        finally {
            long resultingPosition = initialPosition + (long)(offset - initialOffset);
            if (resultingPosition > initialPosition && !this.isClosed) {
                this.subscriberPosition.setRelease(resultingPosition);
            }
        }
        return fragmentsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int boundedPoll(FragmentHandler handler, long limitPosition, int fragmentLimit) {
        int initialOffset;
        int offset;
        if (this.isClosed) {
            return 0;
        }
        long initialPosition = this.subscriberPosition.get();
        if (initialPosition >= limitPosition) {
            return 0;
        }
        int fragmentsRead = 0;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int limitOffset = (int)Math.min((long)termBuffer.capacity(), limitPosition - initialPosition + (long)offset);
        Header header = this.header;
        header.buffer((DirectBuffer)termBuffer);
        try {
            int alignedLength;
            for (offset = initialOffset = (int)initialPosition & this.termLengthMask; fragmentsRead < fragmentLimit && offset < limitOffset && !this.isClosed; offset += alignedLength) {
                int length = FrameDescriptor.frameLengthVolatile(termBuffer, offset);
                if (length <= 0) {
                    break;
                }
                int frameOffset = offset;
                alignedLength = BitUtil.align((int)length, (int)32);
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, length - 32, header);
            }
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        finally {
            long resultingPosition = initialPosition + (long)(offset - initialOffset);
            if (resultingPosition > initialPosition && !this.isClosed) {
                this.subscriberPosition.setRelease(resultingPosition);
            }
        }
        return fragmentsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int boundedControlledPoll(ControlledFragmentHandler handler, long limitPosition, int fragmentLimit) {
        int initialOffset;
        if (this.isClosed) {
            return 0;
        }
        Position subscriberPosition = this.subscriberPosition;
        long initialPosition = subscriberPosition.get();
        if (initialPosition >= limitPosition) {
            return 0;
        }
        int fragmentsRead = 0;
        int offset = initialOffset = (int)initialPosition & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int limitOffset = (int)Math.min((long)termBuffer.capacity(), limitPosition - initialPosition + (long)offset);
        Header header = this.header;
        header.buffer((DirectBuffer)termBuffer);
        try {
            while (fragmentsRead < fragmentLimit && offset < limitOffset && !this.isClosed) {
                int length = FrameDescriptor.frameLengthVolatile(termBuffer, offset);
                if (length <= 0) {
                    break;
                }
                int frameOffset = offset;
                int alignedLength = BitUtil.align((int)length, (int)32);
                offset += alignedLength;
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                ControlledFragmentHandler.Action action = handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, length - 32, header);
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    --fragmentsRead;
                    offset -= alignedLength;
                    break;
                }
                if (ControlledFragmentHandler.Action.BREAK == action) {
                    break;
                }
                if (ControlledFragmentHandler.Action.COMMIT != action) continue;
                initialPosition += (long)(offset - initialOffset);
                initialOffset = offset;
                if (this.isClosed) continue;
                subscriberPosition.setRelease(initialPosition);
            }
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        finally {
            long resultingPosition = initialPosition + (long)(offset - initialOffset);
            if (resultingPosition > initialPosition && !this.isClosed) {
                subscriberPosition.setRelease(resultingPosition);
            }
        }
        return fragmentsRead;
    }

    public long controlledPeek(long initialPosition, ControlledFragmentHandler handler, long limitPosition) {
        int initialOffset;
        if (this.isClosed) {
            return initialPosition;
        }
        this.validatePosition(initialPosition);
        if (initialPosition >= limitPosition) {
            return initialPosition;
        }
        int offset = initialOffset = (int)initialPosition & this.termLengthMask;
        long position = initialPosition;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        Header header = this.header;
        int limitOffset = (int)Math.min((long)termBuffer.capacity(), limitPosition - initialPosition + (long)offset);
        header.buffer((DirectBuffer)termBuffer);
        long resultingPosition = initialPosition;
        try {
            int length;
            while (offset < limitOffset && !this.isClosed && (length = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0) {
                int frameOffset = offset;
                offset += BitUtil.align((int)length, (int)32);
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) {
                    initialOffset = offset;
                    resultingPosition = position += (long)(offset - initialOffset);
                    continue;
                }
                header.offset(frameOffset);
                ControlledFragmentHandler.Action action = handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, length - 32, header);
                if (ControlledFragmentHandler.Action.ABORT != action) {
                    position += (long)(offset - initialOffset);
                    initialOffset = offset;
                    if ((header.flags() & 0x40) == 64) {
                        resultingPosition = position;
                    }
                    if (ControlledFragmentHandler.Action.BREAK != action) continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        return resultingPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockPoll(BlockHandler handler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int offset = (int)position & this.termLengthMask;
        int limitOffset = Math.min(offset + blockLengthLimit, this.termLengthMask + 1);
        UnsafeBuffer termBuffer = this.activeTermBuffer(position);
        int resultingOffset = TermBlockScanner.scan(termBuffer, offset, limitOffset);
        int length = resultingOffset - offset;
        if (resultingOffset > offset) {
            try {
                int termId = termBuffer.getInt(offset + 20, ByteOrder.LITTLE_ENDIAN);
                handler.onBlock((DirectBuffer)termBuffer, offset, length, this.sessionId, termId);
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
            }
            finally {
                if (!this.isClosed) {
                    this.subscriberPosition.setRelease(position + (long)length);
                }
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rawPoll(RawBlockHandler handler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int offset = (int)position & this.termLengthMask;
        int activeIndex = LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift);
        UnsafeBuffer termBuffer = this.termBuffers[activeIndex];
        int capacity = termBuffer.capacity();
        int limitOffset = Math.min(offset + blockLengthLimit, capacity);
        int resultingOffset = TermBlockScanner.scan(termBuffer, offset, limitOffset);
        int length = resultingOffset - offset;
        if (resultingOffset > offset) {
            try {
                long fileOffset = (long)capacity * (long)activeIndex + (long)offset;
                int termId = termBuffer.getInt(offset + 20, ByteOrder.LITTLE_ENDIAN);
                handler.onBlock(this.logBuffers.fileChannel(), fileOffset, termBuffer, offset, length, this.sessionId, termId);
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
            }
            finally {
                if (!this.isClosed) {
                    this.subscriberPosition.setRelease(position + (long)length);
                }
            }
        }
        return length;
    }

    public void reject(String reason) {
        this.subscription.rejectImage(this.correlationId, this.position(), reason);
    }

    private UnsafeBuffer activeTermBuffer(long position) {
        return this.termBuffers[LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift)];
    }

    private void validatePosition(long position) {
        long currentPosition = this.subscriberPosition.get();
        long limitPosition = currentPosition - (currentPosition & (long)this.termLengthMask) + (long)this.termLengthMask + 1L;
        if (position < currentPosition || position > limitPosition) {
            throw new IllegalArgumentException(position + " position out of range: " + currentPosition + "-" + limitPosition);
        }
        if (0L != (position & 0x1FL)) {
            throw new IllegalArgumentException(position + " position not aligned to FRAME_ALIGNMENT");
        }
    }

    LogBuffers logBuffers() {
        return this.logBuffers;
    }

    void close() {
        this.finalPosition = this.subscriberPosition.getVolatile();
        this.eosPosition = LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
        this.isEos = this.finalPosition >= this.eosPosition;
        this.isRevoked = LogBufferDescriptor.isPublicationRevoked(this.logBuffers.metaDataBuffer());
        this.isClosed = true;
    }

    public String toString() {
        return "Image{correlationId=" + this.correlationId + ", sessionId=" + this.sessionId + ", isClosed=" + this.isClosed + ", isEos=" + this.isEndOfStream() + ", initialTermId=" + this.initialTermId + ", termLength=" + this.termBufferLength() + ", joinPosition=" + this.joinPosition + ", position=" + this.position() + ", endOfStreamPosition=" + this.endOfStreamPosition() + ", activeTransportCount=" + this.activeTransportCount() + ", sourceIdentity='" + this.sourceIdentity + "', subscription=" + String.valueOf(this.subscription) + "}";
    }
}

