/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;

public class DestinationByIdMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int RESOURCE_REGISTRATION_ID_OFFSET = 16;
    private static final int DESTINATION_REGISTRATION_ID_OFFSET = 24;
    public static final int MESSAGE_LENGTH = 32;

    @Override
    public DestinationByIdMessageFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        super.wrap(buffer, offset);
        return this;
    }

    public long resourceRegistrationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public DestinationByIdMessageFlyweight resourceRegistrationId(long registrationId) {
        this.buffer.putLong(this.offset + 16, registrationId);
        return this;
    }

    public long destinationRegistrationId() {
        return this.buffer.getLong(this.offset + 24);
    }

    public DestinationByIdMessageFlyweight destinationRegistrationId(long destinationRegistrationId) {
        this.buffer.putLong(this.offset + 24, destinationRegistrationId);
        return this;
    }

    @Override
    public void validateLength(int msgTypeId, int length) {
        if (length < 32) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
    }
}

