/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.agrona.MutableDirectBuffer;

public class PublicationErrorFrameFlyweight {
    private static final int REGISTRATION_ID_OFFSET = 0;
    private static final int IPV6_ADDRESS_LENGTH = 16;
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static final int DESTINATION_REGISTRATION_ID_OFFSET = 8;
    private static final int SESSION_ID_OFFSET = 16;
    private static final int STREAM_ID_OFFSET = 20;
    private static final int RECEIVER_ID_OFFSET = 24;
    private static final int GROUP_TAG_OFFSET = 32;
    private static final int ADDRESS_TYPE_OFFSET = 40;
    private static final int ADDRESS_PORT_OFFSET = 42;
    private static final int ADDRESS_OFFSET = 44;
    private static final int ERROR_CODE_OFFSET = 60;
    private static final int ERROR_MESSAGE_OFFSET = 64;
    private static final short ADDRESS_TYPE_IPV4 = 1;
    private static final short ADDRESS_TYPE_IPV6 = 2;
    private MutableDirectBuffer buffer;
    private int offset;

    public final PublicationErrorFrameFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long registrationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public PublicationErrorFrameFlyweight registrationId(long registrationId) {
        this.buffer.putLong(this.offset + 0, registrationId);
        return this;
    }

    public long destinationRegistrationId() {
        return this.buffer.getLong(this.offset + 8);
    }

    public PublicationErrorFrameFlyweight destinationRegistrationId(long registrationId) {
        this.buffer.putLong(this.offset + 8, registrationId);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 20);
    }

    public PublicationErrorFrameFlyweight streamId(int streamId) {
        this.buffer.putInt(this.offset + 20, streamId);
        return this;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 16);
    }

    public PublicationErrorFrameFlyweight sessionId(int sessionId) {
        this.buffer.putInt(this.offset + 16, sessionId);
        return this;
    }

    public long receiverId() {
        return this.buffer.getLong(this.offset + 24);
    }

    public PublicationErrorFrameFlyweight receiverId(long receiverId) {
        this.buffer.putLong(this.offset + 24, receiverId);
        return this;
    }

    public long groupTag() {
        return this.buffer.getLong(this.offset + 32);
    }

    public PublicationErrorFrameFlyweight groupTag(long groupTag) {
        this.buffer.putLong(this.offset + 32, groupTag);
        return this;
    }

    public PublicationErrorFrameFlyweight sourceAddress(InetSocketAddress sourceAddress) {
        short sourcePort = (short)(sourceAddress.getPort() & 0xFFFF);
        InetAddress address = sourceAddress.getAddress();
        this.buffer.putShort(this.offset + 42, sourcePort);
        this.buffer.putBytes(this.offset + 44, address.getAddress());
        if (address instanceof Inet4Address) {
            this.buffer.putShort(this.offset + 40, (short)1);
            this.buffer.setMemory(this.offset + 44 + 4, 12, (byte)0);
        } else if (address instanceof Inet6Address) {
            this.buffer.putShort(this.offset + 40, (short)2);
        } else {
            throw new IllegalArgumentException("Unknown address type:" + address.getClass().getSimpleName());
        }
        return this;
    }

    public InetSocketAddress sourceAddress() {
        byte[] address;
        short addressType = this.buffer.getShort(this.offset + 40);
        int port = this.buffer.getShort(this.offset + 42) & 0xFFFF;
        if (1 == addressType) {
            address = new byte[4];
        } else if (2 == addressType) {
            address = new byte[16];
        } else {
            throw new IllegalArgumentException("Unknown address type:" + addressType);
        }
        this.buffer.getBytes(this.offset + 44, address);
        try {
            return new InetSocketAddress(Inet4Address.getByAddress(address), port);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Unknown address type:" + addressType, ex);
        }
    }

    public ErrorCode errorCode() {
        return ErrorCode.get(this.buffer.getInt(this.offset + 60));
    }

    public int errorCodeValue() {
        return this.buffer.getInt(this.offset + 60);
    }

    public PublicationErrorFrameFlyweight errorCode(ErrorCode code) {
        this.buffer.putInt(this.offset + 60, code.value());
        return this;
    }

    public String errorMessage() {
        return this.buffer.getStringAscii(this.offset + 64);
    }

    public int appendMessage(Appendable appendable) {
        return this.buffer.getStringAscii(this.offset + 64, appendable);
    }

    public PublicationErrorFrameFlyweight errorMessage(String message) {
        this.buffer.putStringAscii(this.offset + 64, message);
        return this;
    }

    public int length() {
        return 68 + this.buffer.getInt(this.offset + 64);
    }
}

