/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class StaticCounterMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int REGISTRATION_ID_FIELD_OFFSET = 16;
    private static final int COUNTER_TYPE_ID_FIELD_OFFSET = 24;
    private static final int KEY_LENGTH_OFFSET = 28;
    static final int KEY_BUFFER_OFFSET = 32;
    private static final int MINIMUM_LENGTH = 36;

    @Override
    public StaticCounterMessageFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        super.wrap(buffer, offset);
        return this;
    }

    public long registrationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public StaticCounterMessageFlyweight registrationId(long registrationId) {
        this.buffer.putLong(this.offset + 16, registrationId);
        return this;
    }

    public int typeId() {
        return this.buffer.getInt(this.offset + 24);
    }

    public StaticCounterMessageFlyweight typeId(int typeId) {
        this.buffer.putInt(this.offset + 24, typeId);
        return this;
    }

    public int keyBufferOffset() {
        return 32;
    }

    public int keyBufferLength() {
        return this.buffer.getInt(this.offset + 28);
    }

    public StaticCounterMessageFlyweight keyBuffer(DirectBuffer keyBuffer, int keyOffset, int keyLength) {
        this.buffer.putInt(this.offset + 28, keyLength);
        if (null != keyBuffer && keyLength > 0) {
            this.buffer.putBytes(this.offset + 32, keyBuffer, keyOffset, keyLength);
        }
        return this;
    }

    public int labelBufferOffset() {
        return this.labelLengthOffset() + 4;
    }

    public int labelBufferLength() {
        return this.buffer.getInt(this.offset + this.labelLengthOffset());
    }

    public StaticCounterMessageFlyweight labelBuffer(DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        int labelLengthOffset = this.labelLengthOffset();
        this.buffer.putInt(this.offset + labelLengthOffset, labelLength);
        if (null != labelBuffer && labelLength > 0) {
            this.buffer.putBytes(this.offset + labelLengthOffset + 4, labelBuffer, labelOffset, labelLength);
        }
        return this;
    }

    public StaticCounterMessageFlyweight label(String label) {
        this.buffer.putStringAscii(this.offset + this.labelLengthOffset(), label);
        return this;
    }

    public int length() {
        int labelOffset = this.labelLengthOffset();
        return labelOffset + 4 + this.labelBufferLength();
    }

    @Override
    public void validateLength(int msgTypeId, int length) {
        if (length < 36) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
        int labelOffset = this.labelLengthOffset();
        if (length - labelOffset < 4) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short for key: length=" + length);
        }
        int encodedLength = this.length();
        if (length < encodedLength) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short for label: length=" + length + " encodedLength=" + encodedLength);
        }
    }

    public static int computeLength(int keyLength, int labelLength) {
        return 36 + BitUtil.align((int)keyLength, (int)4) + 4 + labelLength;
    }

    public String toString() {
        return "StaticCounterMessageFlyweight{clientId=" + this.clientId() + ", correlationId=" + this.correlationId() + ", registrationId=" + this.registrationId() + ", typeId=" + this.typeId() + ", keyBufferOffset=" + this.keyBufferOffset() + ", keyBufferLength=" + this.keyBufferLength() + ", labelLengthOffset=" + this.labelLengthOffset() + ", labelBufferOffset=" + this.labelBufferOffset() + ", labelBufferLength=" + this.labelBufferLength() + ", length=" + this.length() + "}";
    }

    private int labelLengthOffset() {
        return 32 + BitUtil.align((int)this.keyBufferLength(), (int)4);
    }
}

