/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ReadableCounter
implements AutoCloseable {
    private final CountersReader countersReader;
    private final UnsafeBuffer valueBuffer;
    private final long registrationId;
    private final int counterId;
    private volatile boolean isClosed = false;

    public ReadableCounter(CountersReader countersReader, long registrationId, int counterId) {
        int counterState = countersReader.getCounterState(counterId);
        if (counterState != 1) {
            throw new IllegalStateException("Counter not allocated: id=" + counterId + " state=" + counterState);
        }
        this.countersReader = countersReader;
        this.counterId = counterId;
        this.registrationId = registrationId;
        AtomicBuffer valuesBuffer = countersReader.valuesBuffer();
        int counterOffset = CountersReader.counterOffset((int)counterId);
        valuesBuffer.boundsCheck(counterOffset, 8);
        this.valueBuffer = new UnsafeBuffer((DirectBuffer)valuesBuffer, counterOffset, 8);
    }

    public ReadableCounter(CountersReader countersReader, int counterId) {
        this(countersReader, -1L, counterId);
    }

    public long registrationId() {
        return this.registrationId;
    }

    public int counterId() {
        return this.counterId;
    }

    public int state() {
        return this.countersReader.getCounterState(this.counterId);
    }

    public String label() {
        return this.countersReader.getCounterLabel(this.counterId);
    }

    public long get() {
        return this.valueBuffer.getLongVolatile(0);
    }

    public long getWeak() {
        return this.valueBuffer.getLong(0);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

