/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.BufferBuilder;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.codecs.ClusterActionRequestDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import io.aeron.cluster.codecs.TimerEventDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

final class LogAdapter
implements ControlledFragmentHandler {
    private final int fragmentLimit;
    private long logPosition;
    private Image image;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final BufferBuilder builder = new BufferBuilder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionOpenEventDecoder sessionOpenEventDecoder = new SessionOpenEventDecoder();
    private final SessionCloseEventDecoder sessionCloseEventDecoder = new SessionCloseEventDecoder();
    private final SessionMessageHeaderDecoder sessionHeaderDecoder = new SessionMessageHeaderDecoder();
    private final TimerEventDecoder timerEventDecoder = new TimerEventDecoder();
    private final ClusterActionRequestDecoder clusterActionRequestDecoder = new ClusterActionRequestDecoder();
    private final NewLeadershipTermEventDecoder newLeadershipTermEventDecoder = new NewLeadershipTermEventDecoder();

    LogAdapter(ConsensusModuleAgent consensusModuleAgent, int fragmentLimit) {
        this.consensusModuleAgent = consensusModuleAgent;
        this.fragmentLimit = fragmentLimit;
    }

    long disconnect(ErrorHandler errorHandler) {
        long registrationId = -1L;
        if (null != this.image) {
            this.logPosition = this.image.position();
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.image.subscription());
            registrationId = this.image.subscription().registrationId();
            this.image = null;
        }
        return registrationId;
    }

    void disconnect(ErrorHandler errorHandler, long maxLogPosition) {
        this.consensusModuleAgent.awaitLocalSocketsClosed(this.disconnect(errorHandler));
        this.logPosition = Math.min(this.logPosition, maxLogPosition);
    }

    Subscription subscription() {
        return null == this.image ? null : this.image.subscription();
    }

    ConsensusModuleAgent consensusModuleAgent() {
        return this.consensusModuleAgent;
    }

    long position() {
        if (null == this.image) {
            return this.logPosition;
        }
        return this.image.position();
    }

    int poll(long boundPosition) {
        if (null == this.image) {
            return 0;
        }
        return this.image.boundedControlledPoll((ControlledFragmentHandler)this, boundPosition, this.fragmentLimit);
    }

    boolean isImageClosed() {
        return null == this.image || this.image.isClosed();
    }

    boolean isLogEndOfStream() {
        return null != this.image && this.image.isEndOfStream();
    }

    boolean isLogEndOfStreamAt(long position) {
        return null != this.image && position == this.image.endOfStreamPosition();
    }

    Image image() {
        return this.image;
    }

    void image(Image image) {
        if (null != this.image) {
            this.logPosition = this.image.position();
        }
        this.image = image;
    }

    void asyncRemoveDestination(String destination) {
        if (null != this.image && !this.image.subscription().isClosed()) {
            this.image.subscription().asyncRemoveDestination(destination);
        }
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.onMessage(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().captureHeader(header).append(buffer, offset, length).nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
        } else if (offset == this.builder.nextTermOffset()) {
            int limit = this.builder.limit();
            this.builder.append(buffer, offset, length);
            if ((flags & 0x40) == 64) {
                action = this.onMessage((DirectBuffer)this.builder.buffer(), 0, this.builder.limit(), this.builder.completeHeader(header));
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    this.builder.limit(limit);
                } else {
                    this.builder.reset();
                }
            } else {
                this.builder.nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
            }
        } else {
            this.builder.reset();
        }
        return action;
    }

    private ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        int templateId = this.messageHeaderDecoder.templateId();
        int actingVersion = this.messageHeaderDecoder.version();
        int actingBlockLength = this.messageHeaderDecoder.blockLength();
        if (schemaId != 111) {
            return this.consensusModuleAgent.onReplayExtensionMessage(actingBlockLength, templateId, schemaId, actingVersion, buffer, offset, length, header);
        }
        switch (templateId) {
            case 1: {
                this.sessionHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onReplaySessionMessage(this.sessionHeaderDecoder.clusterSessionId(), this.sessionHeaderDecoder.timestamp());
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            case 20: {
                this.timerEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onReplayTimerEvent(this.timerEventDecoder.correlationId());
                break;
            }
            case 21: {
                this.sessionOpenEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onReplaySessionOpen(header.position(), this.sessionOpenEventDecoder.correlationId(), this.sessionOpenEventDecoder.clusterSessionId(), this.sessionOpenEventDecoder.timestamp(), this.sessionOpenEventDecoder.responseStreamId(), this.sessionOpenEventDecoder.responseChannel());
                break;
            }
            case 22: {
                this.sessionCloseEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onReplaySessionClose(this.sessionCloseEventDecoder.clusterSessionId(), this.sessionCloseEventDecoder.closeReason());
                break;
            }
            case 23: {
                this.clusterActionRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                int flags = ClusterActionRequestDecoder.flagsNullValue() != this.clusterActionRequestDecoder.flags() ? this.clusterActionRequestDecoder.flags() : 0;
                this.consensusModuleAgent.onReplayClusterAction(this.clusterActionRequestDecoder.leadershipTermId(), this.clusterActionRequestDecoder.logPosition(), this.clusterActionRequestDecoder.timestamp(), this.clusterActionRequestDecoder.action(), flags);
                return ControlledFragmentHandler.Action.BREAK;
            }
            case 24: {
                this.newLeadershipTermEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onReplayNewLeadershipTermEvent(this.newLeadershipTermEventDecoder.leadershipTermId(), this.newLeadershipTermEventDecoder.logPosition(), this.newLeadershipTermEventDecoder.timestamp(), this.newLeadershipTermEventDecoder.termBaseLogPosition(), ClusterClock.map(this.newLeadershipTermEventDecoder.timeUnit()), this.newLeadershipTermEventDecoder.appVersion());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

