/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Response code for an admin command request.
 */
@SuppressWarnings("all")
public enum AdminResponseCode
{

    /**
     * Command was submitted or executed successfully.
     */
    OK(0),


    /**
     * An error occurred during admin operation.
     */
    ERROR(1),


    /**
     * Admin request was not authorised.
     */
    UNAUTHORISED_ACCESS(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    AdminResponseCode(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static AdminResponseCode get(final int value)
    {
        switch (value)
        {
            case 0: return OK;
            case 1: return ERROR;
            case 2: return UNAUTHORISED_ACCESS;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
