/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ConsensusModuleSnapshotListener;
import io.aeron.cluster.codecs.CloseReason;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;

class ConsensusModuleSnapshotPrinter
implements ConsensusModuleSnapshotListener {
    private final PrintStream out;

    ConsensusModuleSnapshotPrinter(PrintStream out) {
        this.out = out;
    }

    @Override
    public void onLoadBeginSnapshot(int appVersion, TimeUnit timeUnit, DirectBuffer buffer, int offset, int length) {
        this.out.println("Snapshot: appVersion=" + appVersion + " timeUnit=" + String.valueOf((Object)timeUnit));
    }

    @Override
    public void onLoadEndSnapshot(DirectBuffer buffer, int offset, int length) {
        this.out.println("End Snapshot, offset=" + offset + ", length=" + length);
        byte[] b = new byte[length];
        buffer.getBytes(offset, b, 0, length);
        this.out.println(ConsensusModuleSnapshotPrinter.formatHexDump(b, 0, length));
    }

    @Override
    public void onLoadConsensusModuleState(long nextSessionId, long nextServiceSessionId, long logServiceSessionId, int pendingMessageCapacity, DirectBuffer buffer, int offset, int length) {
        this.out.println("Consensus Module State: nextSessionId=" + nextSessionId + " nextServiceSessionId=" + nextServiceSessionId + " logServiceSessionId=" + logServiceSessionId + " pendingMessageCapacity=" + pendingMessageCapacity);
        byte[] b = new byte[length];
        buffer.getBytes(offset, b, 0, length);
        this.out.println(ConsensusModuleSnapshotPrinter.formatHexDump(b, 0, length));
    }

    @Override
    public void onLoadPendingMessage(long clusterSessionId, DirectBuffer buffer, int offset, int length) {
        this.out.println("Pending Message: length=" + length + " clusterSessionId=" + clusterSessionId);
    }

    @Override
    public void onLoadClusterSession(long clusterSessionId, long correlationId, long openedLogPosition, long timeOfLastActivity, CloseReason closeReason, int responseStreamId, String responseChannel, DirectBuffer buffer, int offset, int length) {
        this.out.println("Cluster Session: clusterSessionId=" + clusterSessionId + " correlationId=" + correlationId + " openedLogPosition=" + openedLogPosition + " timeOfLastActivity=" + timeOfLastActivity + " closeReason=" + String.valueOf((Object)closeReason) + " responseStreamId=" + responseStreamId + " responseChannel=" + responseChannel);
    }

    @Override
    public void onLoadTimer(long correlationId, long deadline, DirectBuffer buffer, int offset, int length) {
        this.out.println("Timer: correlationId=" + correlationId + " deadline=" + deadline);
    }

    @Override
    public void onLoadPendingMessageTracker(long nextServiceSessionId, long logServiceSessionId, int pendingMessageCapacity, int serviceId, DirectBuffer buffer, int offset, int length) {
        this.out.println("Pending Message Tracker: nextServiceSessionId=" + nextServiceSessionId + " logServiceSessionId=" + logServiceSessionId + " pendingMessageCapacity=" + pendingMessageCapacity + " serviceId=" + serviceId);
    }

    private static String formatHexDump(byte[] array, int offset, int length) {
        int width = 16;
        StringBuilder builder = new StringBuilder();
        for (int rowOffset = offset; rowOffset < offset + length; rowOffset += 16) {
            builder.append(String.format("%06d:  ", rowOffset));
            for (int index = 0; index < 16; ++index) {
                if (rowOffset + index < array.length) {
                    builder.append(String.format("%02x ", array[rowOffset + index]));
                    continue;
                }
                builder.append("   ");
            }
            if (rowOffset < array.length) {
                int asciiWidth = Math.min(16, array.length - rowOffset);
                builder.append("  |  ");
                builder.append(new String(array, rowOffset, asciiWidth, StandardCharsets.UTF_8).replaceAll("\r\n", " ").replaceAll("\n", " "));
            }
            builder.append(String.format("%n", new Object[0]));
        }
        return builder.toString();
    }
}

