/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.DirectBufferVector;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.client.ControlledEgressListener;
import io.aeron.cluster.client.ControlledEgressListenerExtension;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.client.EgressListenerExtension;
import io.aeron.cluster.client.EgressPoller;
import io.aeron.cluster.codecs.AdminRequestEncoder;
import io.aeron.cluster.codecs.AdminRequestType;
import io.aeron.cluster.codecs.AdminResponseCode;
import io.aeron.cluster.codecs.AdminResponseDecoder;
import io.aeron.cluster.codecs.ChallengeResponseEncoder;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestEncoder;
import io.aeron.cluster.codecs.SessionConnectRequestEncoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveEncoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.exceptions.TimeoutException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.security.AuthenticationException;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.agrona.AsciiEncoding;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;

public final class AeronCluster
implements AutoCloseable {
    public static final int SESSION_HEADER_LENGTH = 32;
    private static final int SEND_ATTEMPTS = 3;
    private static final int FRAGMENT_LIMIT = 10;
    private final long clusterSessionId;
    private long leadershipTermId;
    private int leaderMemberId;
    private final Context ctx;
    private final Subscription subscription;
    private State state;
    private long stateDeadline;
    private Image egressImage;
    private Publication publication;
    private final NanoClock nanoClock;
    private final IdleStrategy idleStrategy;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);
    private final DirectBufferVector headerVector = new DirectBufferVector((DirectBuffer)this.headerBuffer, 0, 32);
    private final MessageHeaderEncoder messageHeaderEncoder;
    private final SessionMessageHeaderEncoder sessionMessageHeaderEncoder = new SessionMessageHeaderEncoder();
    private final SessionKeepAliveEncoder sessionKeepAliveEncoder = new SessionKeepAliveEncoder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final AdminRequestEncoder adminRequestEncoder = new AdminRequestEncoder();
    private final AdminResponseDecoder adminResponseDecoder = new AdminResponseDecoder();
    private final FragmentAssembler fragmentAssembler;
    private final EgressListener egressListener;
    private final ControlledFragmentAssembler controlledFragmentAssembler;
    private final ControlledEgressListener controlledEgressListener;
    private EgressListenerExtension egressListenerExtension;
    private ControlledEgressListenerExtension controlledEgressListenerExtension;
    private Int2ObjectHashMap<MemberIngress> endpointByIdMap;

    public static AeronCluster connect() {
        return AeronCluster.connect(new Context());
    }

    public static AeronCluster connect(Context ctx) {
        AsyncConnect asyncConnect = null;
        try {
            AeronCluster aeronCluster;
            ctx.conclude();
            Aeron aeron = ctx.aeron();
            long deadlineNs = aeron.context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            asyncConnect = new AsyncConnect(ctx, deadlineNs);
            AgentInvoker aeronClientInvoker = aeron.conductorAgentInvoker();
            AgentInvoker agentInvoker = ctx.agentInvoker();
            IdleStrategy idleStrategy = ctx.idleStrategy();
            AsyncConnect.State state = asyncConnect.state();
            while (null == (aeronCluster = asyncConnect.poll())) {
                if (null != aeronClientInvoker) {
                    aeronClientInvoker.invoke();
                }
                if (null != agentInvoker) {
                    agentInvoker.invoke();
                }
                if (state != asyncConnect.state()) {
                    state = asyncConnect.state();
                    idleStrategy.reset();
                    continue;
                }
                idleStrategy.idle();
            }
            return aeronCluster;
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{asyncConnect});
            }
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static AsyncConnect asyncConnect() {
        return AeronCluster.asyncConnect(new Context());
    }

    public static AsyncConnect asyncConnect(Context ctx) {
        try {
            ctx.conclude();
            long deadlineNs = ctx.aeron().context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            return new AsyncConnect(ctx, deadlineNs);
        }
        catch (Exception ex) {
            ctx.close();
            throw ex;
        }
    }

    AeronCluster(Context ctx, MessageHeaderEncoder messageHeaderEncoder, Publication publication, Subscription subscription, Image egressImage, Int2ObjectHashMap<MemberIngress> endpointByIdMap, long clusterSessionId, long leadershipTermId, int leaderMemberId) {
        this.ctx = ctx;
        this.messageHeaderEncoder = messageHeaderEncoder;
        this.subscription = subscription;
        this.egressImage = egressImage;
        this.endpointByIdMap = endpointByIdMap;
        this.clusterSessionId = clusterSessionId;
        this.leadershipTermId = leadershipTermId;
        this.leaderMemberId = leaderMemberId;
        this.publication = publication;
        this.nanoClock = ctx.aeron().context().nanoClock();
        this.idleStrategy = ctx.idleStrategy();
        this.egressListener = ctx.egressListener();
        this.fragmentAssembler = new FragmentAssembler(this::onFragment, 0, ctx.isDirectAssemblers());
        this.controlledEgressListener = ctx.controlledEgressListener();
        this.controlledFragmentAssembler = new ControlledFragmentAssembler(this::onControlledFragment, 0, ctx.isDirectAssemblers());
        this.sessionMessageHeaderEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.headerBuffer, 0, messageHeaderEncoder).clusterSessionId(clusterSessionId).leadershipTermId(leadershipTermId);
        this.state(State.CONNECTED, 0L);
    }

    public void egressListenerExtension(EgressListenerExtension listenerExtension) {
        this.egressListenerExtension = listenerExtension;
    }

    public void controlledEgressListenerExtension(ControlledEgressListenerExtension listenerExtension) {
        this.controlledEgressListenerExtension = listenerExtension;
    }

    @Override
    public void close() {
        if (State.CLOSED == this.state) {
            return;
        }
        if (null != this.publication && this.publication.isConnected() && State.CONNECTED == this.state) {
            this.closeSession();
        }
        if (!this.ctx.ownsAeronClient()) {
            ErrorHandler errorHandler = this.ctx.errorHandler();
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.subscription);
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.publication);
        }
        this.state(State.CLOSED, 0L);
        this.ctx.close();
    }

    public boolean isClosed() {
        return State.CLOSED == this.state;
    }

    public Context context() {
        return this.ctx;
    }

    public long clusterSessionId() {
        return this.clusterSessionId;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public int leaderMemberId() {
        return this.leaderMemberId;
    }

    public Publication ingressPublication() {
        return this.publication;
    }

    public Subscription egressSubscription() {
        return this.subscription;
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        long offset = this.publication.tryClaim(length + 32, bufferClaim);
        this.trackIngressPublicationResult(offset);
        if (offset > 0L) {
            bufferClaim.putBytes((DirectBuffer)this.headerBuffer, 0, 32);
        }
        return offset;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        long result = this.publication.offer((DirectBuffer)this.headerBuffer, 0, 32, buffer, offset, length, null);
        this.trackIngressPublicationResult(result);
        return result;
    }

    public long offer(DirectBufferVector[] vectors) {
        vectors[0] = this.headerVector;
        long result = this.publication.offer(vectors, null);
        this.trackIngressPublicationResult(result);
        return result;
    }

    public boolean sendKeepAlive() {
        this.idleStrategy.reset();
        int attempts = 3;
        int length = 24;
        while (true) {
            long position = this.publication.tryClaim(24, this.bufferClaim);
            this.trackIngressPublicationResult(position);
            if (position > 0L) {
                this.sessionKeepAliveEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(this.leadershipTermId).clusterSessionId(this.clusterSessionId);
                this.bufferClaim.commit();
                return true;
            }
            if (position == -5L) {
                throw new ClusterException("max position exceeded: term-length=" + this.publication.termBufferLength());
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
            this.invokeInvokers();
        }
        return false;
    }

    public boolean sendAdminRequestToTakeASnapshot(long correlationId) {
        this.idleStrategy.reset();
        int attempts = 3;
        int length = 36 + AdminRequestEncoder.payloadHeaderLength();
        while (true) {
            long position = this.publication.tryClaim(length, this.bufferClaim);
            this.trackIngressPublicationResult(position);
            if (position > 0L) {
                this.adminRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(this.leadershipTermId).clusterSessionId(this.clusterSessionId).correlationId(correlationId).requestType(AdminRequestType.SNAPSHOT).putPayload(ArrayUtil.EMPTY_BYTE_ARRAY, 0, 0);
                this.bufferClaim.commit();
                return true;
            }
            if (position == -4L) {
                throw new ClusterException("ingress publication is closed");
            }
            if (position == -5L) {
                throw new ClusterException("max position exceeded: term-length=" + this.publication.termBufferLength());
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
            this.invokeInvokers();
        }
        return false;
    }

    public int pollEgress() {
        int workCount = this.subscription.poll((FragmentHandler)this.fragmentAssembler, 10);
        if (this.egressImage.isClosed() && (State.CONNECTED == this.state || State.AWAIT_NEW_LEADER_CONNECTION == this.state)) {
            this.onDisconnected();
            ++workCount;
        }
        return workCount += this.pollStateChanges();
    }

    public int controlledPollEgress() {
        int workCount = this.subscription.controlledPoll((ControlledFragmentHandler)this.controlledFragmentAssembler, 10);
        if (this.egressImage.isClosed() && (State.CONNECTED == this.state || State.AWAIT_NEW_LEADER_CONNECTION == this.state)) {
            this.onDisconnected();
            ++workCount;
        }
        return workCount += this.pollStateChanges();
    }

    public int pollStateChanges() {
        if (State.PENDING_CLOSE == this.state || (State.AWAIT_NEW_LEADER == this.state || State.AWAIT_NEW_LEADER_CONNECTION == this.state) && 0L <= this.nanoClock.nanoTime() - this.stateDeadline) {
            this.close();
            return 1;
        }
        return 0;
    }

    public void onNewLeader(long clusterSessionId, long leadershipTermId, int leaderMemberId, String ingressEndpoints) {
        if (clusterSessionId != this.clusterSessionId) {
            throw new ClusterException("invalid clusterSessionId=" + clusterSessionId + " expected=" + this.clusterSessionId);
        }
        this.state(State.AWAIT_NEW_LEADER_CONNECTION, this.nanoClock.nanoTime() + this.ctx.messageTimeoutNs());
        this.leadershipTermId = leadershipTermId;
        this.leaderMemberId = leaderMemberId;
        this.sessionMessageHeaderEncoder.leadershipTermId(leadershipTermId);
        CloseHelper.close((AutoCloseable)this.publication);
        if (null == this.ctx.ingressEndpoints()) {
            this.publication = AeronCluster.addIngressPublication(this.ctx, this.ctx.ingressChannel(), this.ctx.ingressStreamId());
        } else {
            this.ctx.ingressEndpoints(ingressEndpoints);
            this.updateMemberEndpoints(ingressEndpoints, leaderMemberId);
        }
        this.fragmentAssembler.clear();
        this.controlledFragmentAssembler.clear();
        this.egressListener.onNewLeader(clusterSessionId, leadershipTermId, leaderMemberId, ingressEndpoints);
        this.controlledEgressListener.onNewLeader(clusterSessionId, leadershipTermId, leaderMemberId, ingressEndpoints);
    }

    public void trackIngressPublicationResult(long result) {
        if (State.CONNECTED == this.state) {
            if (-1L == result || -4L == result) {
                this.onDisconnected();
            } else if (-5L == result) {
                this.publication.close();
                this.state(State.PENDING_CLOSE, 0L);
            }
        } else if (State.AWAIT_NEW_LEADER_CONNECTION == this.state && 0L < result) {
            this.state(State.CONNECTED, 0L);
        }
    }

    static Int2ObjectHashMap<MemberIngress> parseIngressEndpoints(Context ctx, String endpoints) {
        Int2ObjectHashMap endpointByIdMap = new Int2ObjectHashMap();
        if (null != endpoints) {
            for (String endpoint : endpoints.split(",")) {
                int i = endpoint.indexOf(61);
                if (-1 == i) {
                    throw new ConfigurationException("endpoint missing '=' separator: " + endpoints);
                }
                int memberId = AsciiEncoding.parseIntAscii((CharSequence)endpoint, (int)0, (int)i);
                endpointByIdMap.put(memberId, (Object)new MemberIngress(ctx, memberId, endpoint.substring(i + 1)));
            }
        }
        return endpointByIdMap;
    }

    static Publication addIngressPublication(Context ctx, String channel, int streamId) {
        if (ctx.isIngressExclusive()) {
            return ctx.aeron().addExclusivePublication(channel, streamId);
        }
        return ctx.aeron().addPublication(channel, streamId);
    }

    static long asyncAddIngressPublication(Context ctx, String channel, int streamId) {
        if (ctx.isIngressExclusive()) {
            return ctx.aeron().asyncAddExclusivePublication(channel, streamId);
        }
        return ctx.aeron().asyncAddPublication(channel, streamId);
    }

    static Publication getIngressPublication(Context ctx, long registrationId) {
        if (ctx.isIngressExclusive()) {
            return ctx.aeron().getExclusivePublication(registrationId);
        }
        return ctx.aeron().getPublication(registrationId);
    }

    private void updateMemberEndpoints(String ingressEndpoints, int leaderMemberId) {
        CloseHelper.closeAll((Collection)this.endpointByIdMap.values());
        Int2ObjectHashMap<MemberIngress> map = AeronCluster.parseIngressEndpoints(this.ctx, ingressEndpoints);
        MemberIngress newLeader = (MemberIngress)map.get(leaderMemberId);
        ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.ingressChannel());
        if (channelUri.isUdp()) {
            channelUri.put("endpoint", newLeader.endpoint);
        }
        this.publication = newLeader.publication = AeronCluster.addIngressPublication(this.ctx, channelUri.toString(), this.ctx.ingressStreamId());
        this.endpointByIdMap = map;
    }

    private void onDisconnected() {
        this.publication.close();
        this.state(State.AWAIT_NEW_LEADER, this.nanoClock.nanoTime() + this.ctx.newLeaderTimeoutNs());
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        int templateId = this.messageHeaderDecoder.templateId();
        if (schemaId != 111) {
            if (this.egressListenerExtension != null) {
                this.egressListenerExtension.onExtensionMessage(this.messageHeaderDecoder.blockLength(), templateId, schemaId, this.messageHeaderDecoder.version(), buffer, offset + 8, length - 8);
            } else {
                throw new ClusterException("expected cluster egress schemaId=111 actual=" + schemaId);
            }
        }
        switch (templateId) {
            case 1: {
                this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionMessageHeaderDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.egressListener.onMessage(sessionId, this.sessionMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
                break;
            }
            case 2: {
                this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                EventCode code = this.sessionEventDecoder.code();
                if (EventCode.CLOSED == code) {
                    this.state(State.PENDING_CLOSE, 0L);
                }
                this.egressListener.onSessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), code, this.sessionEventDecoder.detail());
                break;
            }
            case 6: {
                this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.newLeaderEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.egressImage = (Image)header.context();
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.ingressEndpoints());
                break;
            }
            case 27: {
                this.adminResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.adminResponseDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                long correlationId = this.adminResponseDecoder.correlationId();
                AdminRequestType requestType = this.adminResponseDecoder.requestType();
                AdminResponseCode responseCode = this.adminResponseDecoder.responseCode();
                String message = this.adminResponseDecoder.message();
                int payloadOffset = this.adminResponseDecoder.offset() + 24 + AdminResponseDecoder.messageHeaderLength() + message.length() + AdminResponseDecoder.payloadHeaderLength();
                int payloadLength = this.adminResponseDecoder.payloadLength();
                this.egressListener.onAdminResponse(sessionId, correlationId, requestType, responseCode, message, buffer, payloadOffset, payloadLength);
                break;
            }
        }
    }

    private ControlledFragmentHandler.Action onControlledFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        int templateId = this.messageHeaderDecoder.templateId();
        if (schemaId != 111) {
            if (this.controlledEgressListenerExtension != null) {
                return this.controlledEgressListenerExtension.onExtensionMessage(this.messageHeaderDecoder.blockLength(), templateId, schemaId, this.messageHeaderDecoder.version(), buffer, offset + 8, length - 8);
            }
            throw new ClusterException("expected cluster egress schemaId=111 actual=" + schemaId);
        }
        switch (templateId) {
            case 1: {
                this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionMessageHeaderDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                return this.controlledEgressListener.onMessage(sessionId, this.sessionMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
            case 2: {
                this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                EventCode code = this.sessionEventDecoder.code();
                if (EventCode.CLOSED == code) {
                    this.state(State.PENDING_CLOSE, 0L);
                }
                this.controlledEgressListener.onSessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), code, this.sessionEventDecoder.detail());
                break;
            }
            case 6: {
                this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.newLeaderEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.egressImage = (Image)header.context();
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.ingressEndpoints());
                return ControlledFragmentHandler.Action.COMMIT;
            }
            case 27: {
                this.adminResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.adminResponseDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                long correlationId = this.adminResponseDecoder.correlationId();
                AdminRequestType requestType = this.adminResponseDecoder.requestType();
                AdminResponseCode responseCode = this.adminResponseDecoder.responseCode();
                String message = this.adminResponseDecoder.message();
                int payloadOffset = this.adminResponseDecoder.offset() + 24 + AdminResponseDecoder.messageHeaderLength() + message.length() + AdminResponseDecoder.payloadHeaderLength();
                int payloadLength = this.adminResponseDecoder.payloadLength();
                this.controlledEgressListener.onAdminResponse(sessionId, correlationId, requestType, responseCode, message, buffer, payloadOffset, payloadLength);
                break;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void closeSession() {
        this.idleStrategy.reset();
        int length = 24;
        SessionCloseRequestEncoder sessionCloseRequestEncoder = new SessionCloseRequestEncoder();
        int attempts = 3;
        while (true) {
            long position = this.publication.tryClaim(24, this.bufferClaim);
            this.trackIngressPublicationResult(position);
            if (position > 0L) {
                sessionCloseRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(this.leadershipTermId).clusterSessionId(this.clusterSessionId);
                this.bufferClaim.commit();
                break;
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
            this.invokeInvokers();
        }
    }

    private void invokeInvokers() {
        if (null != this.ctx.aeron().conductorAgentInvoker()) {
            this.ctx.aeron().conductorAgentInvoker().invoke();
        }
        if (null != this.ctx.agentInvoker()) {
            this.ctx.agentInvoker().invoke();
        }
    }

    private void state(State newState, long newStateDeadline) {
        this.state = newState;
        this.stateDeadline = newStateDeadline;
    }

    public static final class Context
    implements Cloneable {
        private static final VarHandle IS_CONCLUDED_VH;
        private volatile boolean isConcluded;
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private long newLeaderTimeoutNs = -1L;
        private String ingressEndpoints = Configuration.ingressEndpoints();
        private String ingressChannel = Configuration.ingressChannel();
        private int ingressStreamId = Configuration.ingressStreamId();
        private String egressChannel = Configuration.egressChannel();
        private int egressStreamId = Configuration.egressStreamId();
        private IdleStrategy idleStrategy;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private CredentialsSupplier credentialsSupplier;
        private boolean ownsAeronClient = false;
        private boolean isIngressExclusive = true;
        private ErrorHandler errorHandler = Aeron.Configuration.DEFAULT_ERROR_HANDLER;
        private boolean isDirectAssemblers = false;
        private EgressListener egressListener;
        private ControlledEgressListener controlledEgressListener;
        private AgentInvoker agentInvoker;
        private String clientName = Configuration.clientName();

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (IS_CONCLUDED_VH.getAndSet(this, true)) {
                throw new ConcurrentConcludeException();
            }
            if (Strings.isEmpty((String)this.ingressChannel)) {
                throw new ConfigurationException("ingressChannel must be specified");
            }
            if (this.ingressChannel.startsWith("aeron:ipc") && null != this.ingressEndpoints) {
                throw new ConfigurationException("AeronCluster.Context ingressEndpoints must be null when using IPC ingress");
            }
            if (Strings.isEmpty((String)this.egressChannel)) {
                throw new ConfigurationException("egressChannel must be specified");
            }
            ChannelUri egressChannelUri = ChannelUri.parse((CharSequence)this.egressChannel);
            if (egressChannelUri.isUdp()) {
                egressChannelUri.put("rejoin", "false");
                this.egressChannel = egressChannelUri.toString();
            }
            if (this.clientName.length() > 100) {
                throw new ConfigurationException("AeronCluster.Context.clientName length must be <= 100");
            }
            if (null == this.aeron) {
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).clientName(this.clientName.isEmpty() ? "cluster-client" : this.clientName));
                this.ownsAeronClient = true;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(1L, 10L, 1000L, 1000L);
            }
            if (null == this.credentialsSupplier) {
                this.credentialsSupplier = new NullCredentialsSupplier();
            }
            if (null == this.egressListener) {
                this.egressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("egressListener must be specified on AeronCluster.Context");
                };
            }
            if (null == this.controlledEgressListener) {
                this.controlledEgressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("controlledEgressListener must be specified on AeronCluster.Context");
                };
            }
        }

        public boolean isConcluded() {
            return this.isConcluded;
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return CommonContext.checkDebugTimeout((long)this.messageTimeoutNs, (TimeUnit)TimeUnit.NANOSECONDS);
        }

        public Context newLeaderTimeoutNs(long newLeaderTimeoutNs) {
            if (0L >= newLeaderTimeoutNs && -1L != newLeaderTimeoutNs) {
                throw new IllegalArgumentException("newLeaderTimeoutNs must be positive or -1, but was " + newLeaderTimeoutNs);
            }
            this.newLeaderTimeoutNs = newLeaderTimeoutNs;
            return this;
        }

        public long newLeaderTimeoutNs() {
            return CommonContext.checkDebugTimeout((long)this.newLeaderTimeoutNs, (TimeUnit)TimeUnit.NANOSECONDS);
        }

        public Context ingressEndpoints(String clusterMembers) {
            this.ingressEndpoints = clusterMembers;
            return this;
        }

        public String ingressEndpoints() {
            return this.ingressEndpoints;
        }

        public Context ingressChannel(String channel) {
            this.ingressChannel = channel;
            return this;
        }

        public String ingressChannel() {
            return this.ingressChannel;
        }

        public Context ingressStreamId(int streamId) {
            this.ingressStreamId = streamId;
            return this;
        }

        public int ingressStreamId() {
            return this.ingressStreamId;
        }

        public Context egressChannel(String channel) {
            this.egressChannel = channel;
            return this;
        }

        public String egressChannel() {
            return this.egressChannel;
        }

        public Context egressStreamId(int streamId) {
            this.egressStreamId = streamId;
            return this;
        }

        public int egressStreamId() {
            return this.egressStreamId;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context clientName(String clientName) {
            this.clientName = Strings.isEmpty((String)clientName) ? "" : clientName;
            return this;
        }

        public String clientName() {
            return this.clientName;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context isIngressExclusive(boolean isIngressExclusive) {
            this.isIngressExclusive = isIngressExclusive;
            return this;
        }

        public boolean isIngressExclusive() {
            return this.isIngressExclusive;
        }

        public Context credentialsSupplier(CredentialsSupplier credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public CredentialsSupplier credentialsSupplier() {
            return this.credentialsSupplier;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context isDirectAssemblers(boolean isDirectAssemblers) {
            this.isDirectAssemblers = isDirectAssemblers;
            return this;
        }

        public boolean isDirectAssemblers() {
            return this.isDirectAssemblers;
        }

        public Context egressListener(EgressListener listener) {
            this.egressListener = listener;
            return this;
        }

        public EgressListener egressListener() {
            return this.egressListener;
        }

        public Context controlledEgressListener(ControlledEgressListener listener) {
            this.controlledEgressListener = listener;
            return this;
        }

        public ControlledEgressListener controlledEgressListener() {
            return this.controlledEgressListener;
        }

        public Context agentInvoker(AgentInvoker agentInvoker) {
            this.agentInvoker = agentInvoker;
            return this;
        }

        public AgentInvoker agentInvoker() {
            return this.agentInvoker;
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close((AutoCloseable)this.aeron);
            }
        }

        public String toString() {
            return "AeronCluster.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + "'\n    aeron=" + String.valueOf(this.aeron) + "\n    messageTimeoutNs=" + this.messageTimeoutNs + "\n    newLeaderTimeoutNs=" + this.newLeaderTimeoutNs + "\n    ingressEndpoints='" + this.ingressEndpoints + "'\n    ingressChannel='" + this.ingressChannel + "'\n    ingressStreamId=" + this.ingressStreamId + "\n    egressChannel='" + this.egressChannel + "'\n    egressStreamId=" + this.egressStreamId + "\n    idleStrategy=" + String.valueOf(this.idleStrategy) + "\n    credentialsSupplier=" + String.valueOf(this.credentialsSupplier) + "\n    isIngressExclusive=" + this.isIngressExclusive + "\n    errorHandler=" + String.valueOf(this.errorHandler) + "\n    isDirectAssemblers=" + this.isDirectAssemblers + "\n    egressListener=" + String.valueOf(this.egressListener) + "\n    controlledEgressListener=" + String.valueOf(this.controlledEgressListener) + "\n}";
        }

        static {
            try {
                IS_CONCLUDED_VH = MethodHandles.lookup().findVarHandle(Context.class, "isConcluded", Boolean.TYPE);
            }
            catch (ReflectiveOperationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }

    public static final class AsyncConnect
    implements AutoCloseable {
        private Image egressImage;
        private final long deadlineNs;
        private long leaderHeartbeatTimeoutNs;
        private long correlationId = -1L;
        private long clusterSessionId;
        private long leadershipTermId;
        private int leaderMemberId;
        private State state = State.CREATE_EGRESS_SUBSCRIPTION;
        private int messageLength = 0;
        private final Context ctx;
        private final NanoClock nanoClock;
        private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        private Subscription egressSubscription;
        private EgressPoller egressPoller;
        private String responseChannel;
        private long egressRegistrationId = -1L;
        private Int2ObjectHashMap<MemberIngress> memberByIdMap;
        private long ingressRegistrationId = -1L;
        private Publication ingressPublication;

        AsyncConnect(Context ctx, long deadlineNs) {
            this.ctx = ctx;
            this.memberByIdMap = AeronCluster.parseIngressEndpoints(ctx, ctx.ingressEndpoints());
            this.nanoClock = ctx.aeron().context().nanoClock();
            this.deadlineNs = deadlineNs;
        }

        @Override
        public void close() {
            if (State.DONE != this.state) {
                ErrorHandler errorHandler = this.ctx.errorHandler();
                if (null != this.ingressPublication) {
                    CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.ingressPublication);
                } else if (-1L != this.ingressRegistrationId) {
                    this.ctx.aeron().asyncRemovePublication(this.ingressRegistrationId);
                }
                if (null != this.egressSubscription) {
                    CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.egressSubscription);
                } else if (-1L != this.egressRegistrationId) {
                    this.ctx.aeron().asyncRemoveSubscription(this.egressRegistrationId);
                }
                CloseHelper.closeAll((ErrorHandler)errorHandler, (Collection)this.memberByIdMap.values());
                this.ctx.close();
            }
        }

        public int step() {
            return this.state.step;
        }

        public State state() {
            return this.state;
        }

        private void state(State newState) {
            this.state = newState;
        }

        public static String stepName(int step) {
            State state = State.fromStep(step);
            return null != state ? state.name() : "<unknown>";
        }

        public AeronCluster poll() {
            this.checkDeadline();
            switch (this.state) {
                case CREATE_EGRESS_SUBSCRIPTION: {
                    this.createEgressSubscription();
                    break;
                }
                case CREATE_INGRESS_PUBLICATIONS: {
                    this.createIngressPublications();
                    break;
                }
                case AWAIT_PUBLICATION_CONNECTED: {
                    this.awaitPublicationConnected();
                    break;
                }
                case SEND_MESSAGE: {
                    this.sendMessage();
                    break;
                }
                case POLL_RESPONSE: {
                    this.pollResponse();
                    break;
                }
                case CONCLUDE_CONNECT: {
                    return this.concludeConnect();
                }
            }
            return null;
        }

        private void checkDeadline() {
            if (this.deadlineNs - this.nanoClock.nanoTime() < 0L) {
                boolean isConnected;
                boolean bl = isConnected = null != this.egressSubscription && this.egressSubscription.isConnected();
                String egressChannel = null != this.responseChannel ? this.responseChannel : (null != this.egressSubscription ? this.egressSubscription.tryResolveChannelEndpointPort() : "<unknown>");
                TimeoutException ex = new TimeoutException("cluster connect timeout: state=" + String.valueOf((Object)this.state) + " messageTimeout=" + this.ctx.messageTimeoutNs() + "ns ingressChannel=" + this.ctx.ingressChannel() + " ingressEndpoints=" + this.ctx.ingressEndpoints() + " ingressPublication=" + String.valueOf(this.ingressPublication) + " egress.isConnected=" + isConnected + " responseChannel=" + egressChannel);
                for (MemberIngress member : this.memberByIdMap.values()) {
                    if (null == member.publicationException) continue;
                    ex.addSuppressed((Throwable)member.publicationException);
                }
                throw ex;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new AeronException("unexpected interrupt");
            }
        }

        private void createEgressSubscription() {
            if (-1L == this.egressRegistrationId) {
                this.egressRegistrationId = this.ctx.aeron().asyncAddSubscription(this.ctx.egressChannel(), this.ctx.egressStreamId());
            }
            this.egressSubscription = this.ctx.aeron().getSubscription(this.egressRegistrationId);
            if (null != this.egressSubscription) {
                this.egressPoller = new EgressPoller(this.egressSubscription, 10);
                this.egressRegistrationId = -1L;
                this.state(State.CREATE_INGRESS_PUBLICATIONS);
            }
        }

        private void createIngressPublications() {
            if (null == this.ctx.ingressEndpoints()) {
                if (null == this.ingressPublication) {
                    if (-1L == this.ingressRegistrationId) {
                        this.ingressRegistrationId = AeronCluster.asyncAddIngressPublication(this.ctx, this.ctx.ingressChannel(), this.ctx.ingressStreamId());
                    }
                    try {
                        this.ingressPublication = AeronCluster.getIngressPublication(this.ctx, this.ingressRegistrationId);
                    }
                    catch (RegistrationException ex) {
                        this.ingressRegistrationId = -1L;
                        throw ex;
                    }
                } else {
                    this.ingressRegistrationId = -1L;
                    this.state(State.AWAIT_PUBLICATION_CONNECTED);
                }
            } else {
                int count = 0;
                for (MemberIngress member : this.memberByIdMap.values()) {
                    if (null != member.publication || null != member.publicationException) {
                        ++count;
                        continue;
                    }
                    if (-1L == member.registrationId) {
                        member.asyncAddPublication();
                    }
                    member.asyncGetPublication();
                }
                if (this.memberByIdMap.size() == count) {
                    this.state(State.AWAIT_PUBLICATION_CONNECTED);
                }
            }
        }

        private void awaitPublicationConnected() {
            if (null == this.responseChannel) {
                this.responseChannel = this.egressSubscription.tryResolveChannelEndpointPort();
            }
            if (null != this.responseChannel) {
                if (null == this.ingressPublication) {
                    for (MemberIngress member : this.memberByIdMap.values()) {
                        if (null == member.publication && -1L != member.registrationId) {
                            member.asyncGetPublication();
                        }
                        if (null == member.publication || !member.publication.isConnected()) continue;
                        this.ingressPublication = member.publication;
                        this.prepareConnectRequest();
                        break;
                    }
                } else if (this.ingressPublication.isConnected()) {
                    this.prepareConnectRequest();
                }
            }
        }

        private void prepareConnectRequest() {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            byte[] encodedCredentials = this.ctx.credentialsSupplier().encodedCredentials();
            String clientInfo = "name=" + this.ctx.clientName() + " " + AeronCounters.formatVersionInfo((String)"1.49.1", (String)"10f81c92d0");
            SessionConnectRequestEncoder encoder = new SessionConnectRequestEncoder().wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(this.correlationId).responseStreamId(this.ctx.egressStreamId()).version(Configuration.PROTOCOL_SEMANTIC_VERSION).responseChannel(this.responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length).clientInfo(clientInfo);
            this.messageLength = 8 + encoder.encodedLength();
            this.state(State.SEND_MESSAGE);
        }

        private void sendMessage() {
            long position = this.ingressPublication.offer((DirectBuffer)this.buffer, 0, this.messageLength);
            if (position > 0L) {
                this.state(State.POLL_RESPONSE);
            } else if (-4L == position || -1L == position) {
                throw new ClusterException("unexpected loss of connection to cluster");
            }
        }

        private void pollResponse() {
            if (this.egressPoller.poll() > 0 && this.egressPoller.isPollComplete() && this.egressPoller.correlationId() == this.correlationId) {
                if (this.egressPoller.isChallenged()) {
                    this.correlationId = -1L;
                    this.clusterSessionId = this.egressPoller.clusterSessionId();
                    this.prepareChallengeResponse(this.ctx.credentialsSupplier().onChallenge(this.egressPoller.encodedChallenge()));
                    return;
                }
                switch (this.egressPoller.eventCode()) {
                    case OK: {
                        this.leadershipTermId = this.egressPoller.leadershipTermId();
                        this.leaderMemberId = this.egressPoller.leaderMemberId();
                        this.clusterSessionId = this.egressPoller.clusterSessionId();
                        this.leaderHeartbeatTimeoutNs = this.egressPoller.leaderHeartbeatTimeoutNs();
                        this.egressImage = this.egressPoller.egressImage();
                        this.state(State.CONCLUDE_CONNECT);
                        break;
                    }
                    case ERROR: {
                        throw new ClusterException(this.egressPoller.detail());
                    }
                    case REDIRECT: {
                        this.updateMembers();
                        break;
                    }
                    case AUTHENTICATION_REJECTED: {
                        throw new AuthenticationException(this.egressPoller.detail());
                    }
                }
            }
        }

        private void prepareChallengeResponse(byte[] encodedCredentials) {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            ChallengeResponseEncoder encoder = new ChallengeResponseEncoder().wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(this.correlationId).clusterSessionId(this.clusterSessionId).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
            this.messageLength = 8 + encoder.encodedLength();
            this.state(State.SEND_MESSAGE);
        }

        private void updateMembers() {
            this.leaderMemberId = this.egressPoller.leaderMemberId();
            MemberIngress oldLeader = (MemberIngress)this.memberByIdMap.remove(this.leaderMemberId);
            CloseHelper.close((AutoCloseable)this.ingressPublication);
            this.ingressPublication = null;
            CloseHelper.closeAll((Collection)this.memberByIdMap.values());
            this.memberByIdMap = AeronCluster.parseIngressEndpoints(this.ctx, this.egressPoller.detail());
            MemberIngress newLeader = (MemberIngress)this.memberByIdMap.get(this.leaderMemberId);
            if (null != oldLeader && null == oldLeader.publicationException && newLeader.endpoint.equals(oldLeader.endpoint)) {
                this.ingressPublication = newLeader.publication = oldLeader.publication;
                newLeader.registrationId = oldLeader.registrationId;
            } else {
                CloseHelper.close((AutoCloseable)oldLeader);
                newLeader.asyncAddPublication();
            }
            this.state(State.AWAIT_PUBLICATION_CONNECTED);
        }

        private AeronCluster concludeConnect() {
            if (this.ctx.newLeaderTimeoutNs() == -1L) {
                this.ctx.newLeaderTimeoutNs(2L * (this.leaderHeartbeatTimeoutNs != -1L ? this.leaderHeartbeatTimeoutNs : ConsensusModule.Configuration.LEADER_HEARTBEAT_TIMEOUT_DEFAULT_NS));
            }
            AeronCluster aeronCluster = new AeronCluster(this.ctx, this.messageHeaderEncoder, this.ingressPublication, this.egressSubscription, this.egressImage, this.memberByIdMap, this.clusterSessionId, this.leadershipTermId, this.leaderMemberId);
            this.ingressPublication = null;
            this.memberByIdMap.remove(this.leaderMemberId);
            CloseHelper.closeAll((Collection)this.memberByIdMap.values());
            this.state(State.DONE);
            return aeronCluster;
        }

        public static enum State {
            CREATE_EGRESS_SUBSCRIPTION(-1),
            CREATE_INGRESS_PUBLICATIONS(0),
            AWAIT_PUBLICATION_CONNECTED(1),
            SEND_MESSAGE(2),
            POLL_RESPONSE(3),
            CONCLUDE_CONNECT(4),
            DONE(5);

            private static final State[] STATES;
            final int step;

            private State(int step) {
                this.step = step;
            }

            static State fromStep(int step) {
                if (step < State.CREATE_EGRESS_SUBSCRIPTION.step || step > State.DONE.step) {
                    return null;
                }
                return STATES[step + 1];
            }

            static {
                STATES = State.values();
            }
        }
    }

    private static enum State {
        CONNECTED,
        AWAIT_NEW_LEADER,
        AWAIT_NEW_LEADER_CONNECTION,
        PENDING_CLOSE,
        CLOSED;

    }

    static final class MemberIngress
    implements AutoCloseable {
        private final Context ctx;
        final int memberId;
        final String endpoint;
        long registrationId = -1L;
        Publication publication;
        RegistrationException publicationException;

        MemberIngress(Context ctx, int memberId, String endpoint) {
            this.ctx = ctx;
            this.memberId = memberId;
            this.endpoint = endpoint;
        }

        void asyncAddPublication() {
            ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.ingressChannel());
            if (channelUri.isUdp()) {
                channelUri.put("endpoint", this.endpoint);
            }
            this.registrationId = AeronCluster.asyncAddIngressPublication(this.ctx, channelUri.toString(), this.ctx.ingressStreamId());
            this.publication = null;
        }

        void asyncGetPublication() {
            try {
                this.publication = AeronCluster.getIngressPublication(this.ctx, this.registrationId);
                if (null != this.publication) {
                    this.registrationId = -1L;
                }
            }
            catch (RegistrationException ex) {
                this.publicationException = ex;
                this.registrationId = -1L;
            }
        }

        @Override
        public void close() {
            if (null != this.publication) {
                CloseHelper.close((AutoCloseable)this.publication);
            } else if (-1L != this.registrationId) {
                this.ctx.aeron().asyncRemovePublication(this.registrationId);
            }
            this.registrationId = -1L;
            this.publication = null;
        }

        public String toString() {
            return "MemberIngress{memberId=" + this.memberId + ", endpoint='" + this.endpoint + "', publication=" + String.valueOf(this.publication) + "}";
        }
    }

    public static final class Configuration {
        public static final int PROTOCOL_MAJOR_VERSION = 0;
        public static final int PROTOCOL_MINOR_VERSION = 3;
        public static final int PROTOCOL_PATCH_VERSION = 0;
        public static final int PROTOCOL_SEMANTIC_VERSION = SemanticVersion.compose((int)0, (int)3, (int)0);
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.cluster.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String INGRESS_ENDPOINTS_PROP_NAME = "aeron.cluster.ingress.endpoints";
        public static final String INGRESS_ENDPOINTS_DEFAULT = null;
        public static final String INGRESS_CHANNEL_PROP_NAME = "aeron.cluster.ingress.channel";
        public static final String INGRESS_CHANNEL_DEFAULT = null;
        public static final String INGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.ingress.stream.id";
        public static final int INGRESS_STREAM_ID_DEFAULT = 101;
        public static final String EGRESS_CHANNEL_PROP_NAME = "aeron.cluster.egress.channel";
        public static final String EGRESS_CHANNEL_DEFAULT = null;
        public static final String EGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.egress.stream.id";
        public static final int EGRESS_STREAM_ID_DEFAULT = 102;
        public static final String CLIENT_NAME_PROP_NAME = "aeron.cluster.client.name";

        public static long messageTimeoutNs() {
            return SystemUtil.getDurationInNanos((String)MESSAGE_TIMEOUT_PROP_NAME, (long)MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static String ingressEndpoints() {
            return System.getProperty(INGRESS_ENDPOINTS_PROP_NAME, INGRESS_ENDPOINTS_DEFAULT);
        }

        public static String ingressChannel() {
            return System.getProperty(INGRESS_CHANNEL_PROP_NAME, INGRESS_CHANNEL_DEFAULT);
        }

        public static int ingressStreamId() {
            return Integer.getInteger(INGRESS_STREAM_ID_PROP_NAME, 101);
        }

        public static String egressChannel() {
            return System.getProperty(EGRESS_CHANNEL_PROP_NAME, EGRESS_CHANNEL_DEFAULT);
        }

        public static int egressStreamId() {
            return Integer.getInteger(EGRESS_STREAM_ID_PROP_NAME, 102);
        }

        public static String clientName() {
            return SystemUtil.getProperty((String)CLIENT_NAME_PROP_NAME, (String)"");
        }
    }
}

