/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Event for the start of a new leadership term.
 */
@SuppressWarnings("all")
public final class NewLeadershipTermEventEncoder
{
    public static final int BLOCK_LENGTH = 48;
    public static final int TEMPLATE_ID = 24;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final NewLeadershipTermEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public NewLeadershipTermEventEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public NewLeadershipTermEventEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int leadershipTermIdId()
    {
        return 1;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEventEncoder leadershipTermId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int logPositionId()
    {
        return 2;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 8;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEventEncoder logPosition(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int timestampId()
    {
        return 3;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 16;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long timestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEventEncoder timestamp(final long value)
    {
        buffer.putLong(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int termBaseLogPositionId()
    {
        return 4;
    }

    public static int termBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int termBaseLogPositionEncodingOffset()
    {
        return 24;
    }

    public static int termBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long termBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long termBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEventEncoder termBaseLogPosition(final long value)
    {
        buffer.putLong(offset + 24, value, BYTE_ORDER);
        return this;
    }


    public static int leaderMemberIdId()
    {
        return 5;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 32;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public NewLeadershipTermEventEncoder leaderMemberId(final int value)
    {
        buffer.putInt(offset + 32, value, BYTE_ORDER);
        return this;
    }


    public static int logSessionIdId()
    {
        return 6;
    }

    public static int logSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logSessionIdEncodingOffset()
    {
        return 36;
    }

    public static int logSessionIdEncodingLength()
    {
        return 4;
    }

    public static String logSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int logSessionIdNullValue()
    {
        return -2147483648;
    }

    public static int logSessionIdMinValue()
    {
        return -2147483647;
    }

    public static int logSessionIdMaxValue()
    {
        return 2147483647;
    }

    public NewLeadershipTermEventEncoder logSessionId(final int value)
    {
        buffer.putInt(offset + 36, value, BYTE_ORDER);
        return this;
    }


    public static int timeUnitId()
    {
        return 7;
    }

    public static int timeUnitSinceVersion()
    {
        return 4;
    }

    public static int timeUnitEncodingOffset()
    {
        return 40;
    }

    public static int timeUnitEncodingLength()
    {
        return 4;
    }

    public static String timeUnitMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public NewLeadershipTermEventEncoder timeUnit(final ClusterTimeUnit value)
    {
        buffer.putInt(offset + 40, value.value(), BYTE_ORDER);
        return this;
    }

    public static int appVersionId()
    {
        return 8;
    }

    public static int appVersionSinceVersion()
    {
        return 4;
    }

    public static int appVersionEncodingOffset()
    {
        return 44;
    }

    public static int appVersionEncodingLength()
    {
        return 4;
    }

    public static String appVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int appVersionNullValue()
    {
        return 0;
    }

    public static int appVersionMinValue()
    {
        return 1;
    }

    public static int appVersionMaxValue()
    {
        return 16777215;
    }

    public NewLeadershipTermEventEncoder appVersion(final int value)
    {
        buffer.putInt(offset + 44, value, BYTE_ORDER);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final NewLeadershipTermEventDecoder decoder = new NewLeadershipTermEventDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
