/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.DirectBufferVector;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CancelTimerEncoder;
import io.aeron.cluster.codecs.CloseSessionEncoder;
import io.aeron.cluster.codecs.ClusterMembersQueryEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.ScheduleTimerEncoder;
import io.aeron.cluster.codecs.ServiceAckEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

public final class ConsensusModuleProxy
implements AutoCloseable {
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ScheduleTimerEncoder scheduleTimerEncoder = new ScheduleTimerEncoder();
    private final CancelTimerEncoder cancelTimerEncoder = new CancelTimerEncoder();
    private final ServiceAckEncoder serviceAckEncoder = new ServiceAckEncoder();
    private final CloseSessionEncoder closeSessionEncoder = new CloseSessionEncoder();
    private final ClusterMembersQueryEncoder clusterMembersQueryEncoder = new ClusterMembersQueryEncoder();
    private final Publication publication;

    public ConsensusModuleProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.publication);
    }

    boolean scheduleTimer(long correlationId, long deadline) {
        int length = 24;
        long position = this.publication.tryClaim(24, this.bufferClaim);
        if (position > 0L) {
            this.scheduleTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadline);
            this.bufferClaim.commit();
            return true;
        }
        ConsensusModuleProxy.checkResult(position, this.publication);
        return false;
    }

    boolean cancelTimer(long correlationId) {
        int length = 16;
        long position = this.publication.tryClaim(16, this.bufferClaim);
        if (position > 0L) {
            this.cancelTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId);
            this.bufferClaim.commit();
            return true;
        }
        ConsensusModuleProxy.checkResult(position, this.publication);
        return false;
    }

    long offer(DirectBuffer headerBuffer, int headerOffset, int headerLength, DirectBuffer messageBuffer, int messageOffset, int messageLength) {
        long position = this.publication.offer(headerBuffer, headerOffset, headerLength, messageBuffer, messageOffset, messageLength);
        if (position < 0L) {
            ConsensusModuleProxy.checkResult(position, this.publication);
        }
        return position;
    }

    long offer(DirectBufferVector[] vectors) {
        long position = this.publication.offer(vectors, null);
        if (position < 0L) {
            ConsensusModuleProxy.checkResult(position, this.publication);
        }
        return position;
    }

    long tryClaim(int length, BufferClaim bufferClaim, DirectBuffer sessionHeader) {
        long position = this.publication.tryClaim(length, bufferClaim);
        if (position > 0L) {
            bufferClaim.putBytes(sessionHeader, 0, 32);
        } else {
            ConsensusModuleProxy.checkResult(position, this.publication);
        }
        return position;
    }

    boolean ack(long logPosition, long timestamp, long ackId, long relevantId, int serviceId) {
        int length = 44;
        long position = this.publication.tryClaim(44, this.bufferClaim);
        if (position > 0L) {
            this.serviceAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition).timestamp(timestamp).ackId(ackId).relevantId(relevantId).serviceId(serviceId);
            this.bufferClaim.commit();
            return true;
        }
        ConsensusModuleProxy.checkResult(position, this.publication);
        return false;
    }

    boolean closeSession(long clusterSessionId) {
        int length = 16;
        long position = this.publication.tryClaim(16, this.bufferClaim);
        if (position > 0L) {
            this.closeSessionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(clusterSessionId);
            this.bufferClaim.commit();
            return true;
        }
        ConsensusModuleProxy.checkResult(position, this.publication);
        return false;
    }

    public boolean clusterMembersQuery(long correlationId) {
        int length = 20;
        long position = this.publication.tryClaim(20, this.bufferClaim);
        if (position > 0L) {
            this.clusterMembersQueryEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).extended(BooleanType.TRUE);
            this.bufferClaim.commit();
            return true;
        }
        ConsensusModuleProxy.checkResult(position, this.publication);
        return false;
    }

    private static void checkResult(long position, Publication publication) {
        if (-1L == position) {
            throw new ClusterException("publication is not connected");
        }
        if (-4L == position) {
            throw new ClusterException("publication is closed");
        }
        if (-5L == position) {
            throw new ClusterException("publication at max position: term-length=" + publication.termBufferLength());
        }
    }
}

