/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.logging;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LoggerProducer {
    private final Map<Class<?>, Logger> loggers = new ConcurrentHashMap();

    public Logger getLogger(Class<?> targetClass) {
        Logger logger = this.loggers.computeIfAbsent(targetClass, k -> LoggerFactory.getLogger((Class)targetClass));
        return logger;
    }

    @Produces
    public Logger produceLogger(InjectionPoint injectionPoint) {
        Class targetClass = injectionPoint.getBean().getBeanClass();
        return this.getLogger(targetClass);
    }
}

