/*
 * Copyright 2019 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.datamodels.core.models.common;

import io.apicurio.datamodels.core.models.IVisitable;

/**
 * Any node model that represents an example.  This exists because the models for the
 * OpenAPI 2 and OpenAPI 3 example nodes are mutually exclusive.
 * @author eric.wittmann@gmail.com
 */
public interface IExample extends IVisitable, INamed {

    public Object getValue();

    public void setValue(Object value);

}
